/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.area;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.DataContainer;
import net.thenextlvl.protect.area.event.flag.AreaFlagChangeEvent;
import net.thenextlvl.protect.area.event.flag.AreaFlagResetEvent;
import net.thenextlvl.protect.area.event.inheritance.AreaPriorityChangeEvent;
import net.thenextlvl.protect.area.event.member.AreaMemberAddEvent;
import net.thenextlvl.protect.area.event.member.AreaMemberRemoveEvent;
import net.thenextlvl.protect.area.event.member.AreaOwnerChangeEvent;
import net.thenextlvl.protect.flag.Flag;
import net.thenextlvl.protect.io.AreaAdapter;
import org.bukkit.Server;
import org.bukkit.World;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class CraftArea
implements Area {
    protected final ProtectPlugin plugin;
    private final String name;
    private final World world;
    private final Set<UUID> members;
    private @Nullable UUID owner;
    private final Map<Flag<?>, @Nullable Object> flags;
    private int priority;
    private final Map<String, Tag> dataContainer = new LinkedHashMap<String, Tag>();

    protected CraftArea(ProtectPlugin plugin, String name, World world, Set<UUID> members, @Nullable UUID owner, Map<Flag<?>, @Nullable Object> flags, int priority) {
        this.plugin = plugin;
        this.name = name;
        this.world = world;
        this.members = new HashSet<UUID>(members);
        this.owner = owner;
        this.flags = new HashMap(flags);
        this.priority = priority;
    }

    public CraftArea(ProtectPlugin plugin, World world, String name, CompoundTag tag) {
        this.plugin = plugin;
        this.name = name;
        this.world = world;
        this.members = new HashSet<UUID>();
        this.flags = new HashMap();
        this.deserialize(tag);
    }

    @Override
    public Server getServer() {
        return this.plugin.getServer();
    }

    @Override
    public LinkedHashSet<Area> getParents() {
        LinkedHashSet<Area> parents = new LinkedHashSet<Area>();
        Area parent = this.getParent().orElse(null);
        while (parent != null && parent != this && parents.add(parent)) {
            parent = parent.getParent().orElse(null);
        }
        return parents;
    }

    @Override
    public Map<Flag<?>, @Nullable Object> getFlags() {
        return Map.copyOf(this.flags);
    }

    @Override
    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    public boolean isMember(UUID uuid) {
        return this.members.contains(uuid);
    }

    @Override
    public boolean isPermitted(UUID uuid) {
        return this.owner != null && this.owner.equals(uuid) || this.members.contains(uuid);
    }

    @Override
    public boolean removeMember(UUID uuid) {
        AreaMemberRemoveEvent event = new AreaMemberRemoveEvent(this, uuid);
        return event.callEvent() && this.members.remove(event.getMember());
    }

    @Override
    public boolean addMember(UUID uuid) {
        AreaMemberAddEvent event = new AreaMemberAddEvent(this, uuid);
        return event.callEvent() && this.members.add(event.getMember());
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setMembers(Set<UUID> members) {
        if (Objects.equals(members, this.members)) {
            return;
        }
        for (UUID member : this.members) {
            if (members.contains(member)) continue;
            this.removeMember(member);
        }
        for (UUID member : members) {
            if (this.members.contains(member)) continue;
            this.addMember(member);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Set<UUID> getMembers() {
        return Set.copyOf(this.members);
    }

    @Override
    public boolean setOwner(@Nullable UUID owner) {
        if (Objects.equals(owner, this.owner)) {
            return false;
        }
        AreaOwnerChangeEvent event = new AreaOwnerChangeEvent(this, owner);
        if (event.callEvent()) {
            this.owner = event.getOwner();
        }
        return !event.isCancelled();
    }

    @Override
    public boolean setPriority(int priority) {
        if (this.priority == priority) {
            return false;
        }
        AreaPriorityChangeEvent event = new AreaPriorityChangeEvent(this, priority);
        if (!event.callEvent()) {
            return false;
        }
        this.priority = priority;
        return true;
    }

    @Override
    public void setFlags(Map<Flag<?>, @Nullable Object> flags) {
        if (Objects.equals(this.flags, flags)) {
            return;
        }
        flags.forEach((? super K flag, ? super V o) -> this.setFlag((Flag)flag, (Object)o));
    }

    @Override
    @NullUnmarked
    public <T> T getFlag(@NonNull Flag<T> flag) {
        Object value = this.getFlags().get(flag);
        if (value != null) {
            return (T)value;
        }
        return (T)this.getParent().map(area -> area.getFlag(flag)).orElseGet(flag::defaultValue);
    }

    @Override
    @NullUnmarked
    public <T> boolean setFlag(@NonNull Flag<T> flag, T state) {
        if (Objects.equals(this.getFlag(flag), state)) {
            return false;
        }
        AreaFlagChangeEvent<T> event = new AreaFlagChangeEvent<T>(this, flag, state);
        return event.callEvent() && !Objects.equals(this.flags.put(flag, event.getNewState()), event.getNewState());
    }

    @Override
    public <T> boolean removeFlag(Flag<T> flag) {
        if (!this.flags.containsKey(flag)) {
            return false;
        }
        AreaFlagResetEvent<T> event = new AreaFlagResetEvent<T>(this, flag);
        if (event.callEvent()) {
            this.flags.remove(flag);
        }
        return !event.isCancelled();
    }

    @Override
    public <T> boolean hasFlag(Flag<T> flag) {
        return this.flags.containsKey(flag);
    }

    @Override
    public int compareTo(Area area) {
        return Integer.compare(this.getPriority(), area.getPriority());
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag.Builder tag = CompoundTag.builder();
        if (!this.flags.isEmpty()) {
            tag.put("flags", this.plugin.nbt.serialize(this.flags, new TypeToken<Map<Flag<?>, Object>>(){}.getType()));
        }
        if (!this.members.isEmpty()) {
            tag.put("members", this.plugin.nbt.serialize(this.members, new TypeToken<Set<UUID>>(){}.getType()));
        }
        if (!this.dataContainer.isEmpty()) {
            tag.put("data", CompoundTag.of(this.dataContainer));
        }
        if (this.owner != null) {
            tag.put("owner", this.plugin.nbt.serialize(this.owner));
        }
        tag.put("priority", (Number)this.priority);
        AreaAdapter<?> adapter = this.plugin.areaService().getAdapter(this.getClass());
        tag.put("type", adapter.key().asString());
        return tag.build();
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.readFlags(tag).ifPresent(this.flags::putAll);
        this.readMembers(tag).ifPresent(this.members::addAll);
        this.readOwner(tag).ifPresent(owner -> {
            this.owner = owner;
        });
        this.readPriority(tag).ifPresent(priority -> {
            this.priority = priority;
        });
        tag.optional("data").ifPresent(data -> data.forEach(this.dataContainer::put));
    }

    private Optional<Map<Flag<?>, Object>> readFlags(CompoundTag tag) {
        return tag.optional("flags").map(flags -> {
            Type type = new TypeToken<Map<Flag<?>, Object>>(){}.getType();
            return (Map)this.plugin.nbt.deserialize((Tag)flags, type);
        });
    }

    private Optional<Set<UUID>> readMembers(CompoundTag tag) {
        return tag.optional("members").map(members -> (Set)this.plugin.nbt.deserialize((Tag)members, new TypeToken<Set<UUID>>(){}.getType()));
    }

    private Optional<UUID> readOwner(CompoundTag tag) {
        return tag.optional("owner").map(owner -> this.plugin.nbt.deserialize((Tag)owner, UUID.class));
    }

    private Optional<Integer> readPriority(CompoundTag tag) {
        return tag.optional("priority").map(Tag::getAsInt);
    }

    @Override
    public <T extends Tag> Optional<T> get(Key key) {
        return Optional.ofNullable(this.dataContainer.get(key.asString()));
    }

    @Override
    public <T extends Tag> Optional<T> remove(Key key) {
        return Optional.ofNullable(this.dataContainer.remove(key.asString()));
    }

    @Override
    public <T extends Tag> T getOrDefault(Key key, T defaultValue) {
        return (T)this.dataContainer.getOrDefault(key.asString(), defaultValue);
    }

    @Override
    public <T extends Tag> void set(Key key, T value) {
        this.dataContainer.put(key.asString(), value);
    }

    @Override
    public Map<Key, Tag> getTags() {
        return this.dataContainer.entrySet().stream().map(entry -> Map.entry(Key.key((String)((String)entry.getKey())), (Tag)entry.getValue())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Set<Key> getKeys() {
        return this.dataContainer.keySet().stream().map(Key::key).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<Map.Entry<Key, Tag>> entrySet() {
        return this.getTags().entrySet();
    }

    @Override
    public boolean has(Key key) {
        return this.dataContainer.containsKey(key.asString());
    }

    @Override
    public boolean isEmpty() {
        return this.dataContainer.isEmpty();
    }

    @Override
    public void clear() {
        this.dataContainer.clear();
    }

    @Override
    public void copyTo(DataContainer dataContainer) {
        this.copyTo(dataContainer, false);
    }

    @Override
    public void copyTo(DataContainer dataContainer, boolean replace) {
        if (replace) {
            dataContainer.clear();
        }
        this.forEach(dataContainer::set);
    }

    @Override
    public void forEach(BiConsumer<Key, Tag> action) {
        this.entrySet().forEach((? super T entry) -> action.accept((Key)entry.getKey(), (Tag)entry.getValue()));
    }

    public String toString() {
        return "CraftArea{name='" + this.name + "', world=" + String.valueOf(this.world) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftArea craftArea = (CraftArea)o;
        return Objects.equals(this.name, craftArea.name) && Objects.equals(this.world, craftArea.world);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.world);
    }
}

