/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.RegionizedArea;
import net.thenextlvl.protect.command.argument.AreaArgumentType;
import net.thenextlvl.protect.flag.Flag;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class AreaInfoCommand {
    AreaInfoCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").requires(stack -> stack.getSender().hasPermission("protect.command.area.info"))).then(Commands.argument((String)"area", (ArgumentType)new AreaArgumentType(plugin)).executes(context -> {
            Area area = (Area)context.getArgument("area", Area.class);
            return AreaInfoCommand.info((CommandContext<CommandSourceStack>)context, area, plugin);
        }))).executes(context -> {
            Location location = ((CommandSourceStack)context.getSource()).getLocation();
            Area area = plugin.areaProvider().getArea(location);
            return AreaInfoCommand.info((CommandContext<CommandSourceStack>)context, area, plugin);
        });
    }

    private static int info(CommandContext<CommandSourceStack> context, Area area, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String type = plugin.areaService().getAdapter(area.getClass()).key().asString();
        List<Component> flags = area.getFlags().entrySet().stream().map(entry -> plugin.bundle().component("area.flag.format", (Audience)sender, new TagResolver[]{Placeholder.parsed((String)"flag", (String)((Flag)entry.getKey()).key().asString()), Placeholder.unparsed((String)"value", (String)String.valueOf(entry.getValue()))})).toList();
        TextComponent owner = area.getOwner().map(arg_0 -> ((Server)plugin.getServer()).getOfflinePlayer(arg_0)).map(OfflinePlayer::getName).map(Component::text).orElseGet(Component::empty);
        plugin.bundle().sendMessage((Audience)sender, "area.info", new TagResolver[]{Formatter.joining((String)"flags", flags), Placeholder.parsed((String)"area", (String)area.getName()), Placeholder.parsed((String)"file", (String)area.getFile().getPath()), Formatter.number((String)"priority", (Number)area.getPriority()), Formatter.number((String)"size", (Number)(area.getFile().length() / 1024L)), Placeholder.component((String)"owner", (ComponentLike)owner), Placeholder.parsed((String)"type", (String)type), Placeholder.parsed((String)"world", (String)area.getWorld().key().asString())});
        if (!(area instanceof RegionizedArea)) {
            return 1;
        }
        RegionizedArea regionizedArea = (RegionizedArea)area;
        plugin.bundle().sendMessage((Audience)sender, "area.info.bounds", new TagResolver[]{Placeholder.parsed((String)"bounds", (String)(regionizedArea.getRegion().getMinimumPoint().toParserString() + " - " + regionizedArea.getRegion().getMaximumPoint().toParserString()))});
        return 1;
    }
}

