/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag.impl;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.ByteTag;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.DoubleTag;
import net.thenextlvl.nbt.tag.FloatTag;
import net.thenextlvl.nbt.tag.IntTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.LongTag;
import net.thenextlvl.nbt.tag.ShortTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.nbt.tag.impl.ByteArrayTagImpl;
import net.thenextlvl.nbt.tag.impl.ByteTagImpl;
import net.thenextlvl.nbt.tag.impl.DoubleTagImpl;
import net.thenextlvl.nbt.tag.impl.EscapeTagImpl;
import net.thenextlvl.nbt.tag.impl.FloatTagImpl;
import net.thenextlvl.nbt.tag.impl.IntArrayTagImpl;
import net.thenextlvl.nbt.tag.impl.IntTagImpl;
import net.thenextlvl.nbt.tag.impl.LongArrayTagImpl;
import net.thenextlvl.nbt.tag.impl.ShortTagImpl;
import net.thenextlvl.nbt.tag.impl.StringTagImpl;
import net.thenextlvl.nbt.tag.impl.ValueTagImpl;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CompoundTagImpl
extends ValueTagImpl<Map<String, Tag>>
implements CompoundTag {
    public CompoundTagImpl(Map<String, Tag> value) {
        super(value);
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public CompoundTag getAsCompound() {
        return this;
    }

    @Override
    public int getTypeId() {
        return 10;
    }

    @Override
    public void add(String name, Tag tag) {
        ((Map)this.getValue()).put(name, tag);
    }

    @Override
    public @Nullable Tag remove(String name) {
        return (Tag)((Map)this.getValue()).remove(name);
    }

    @Override
    public void add(String name, String value) {
        this.add(name, new StringTagImpl(value));
    }

    @Override
    public void add(String name, byte[] value) {
        this.add(name, new ByteArrayTagImpl(value));
    }

    @Override
    public void add(String name, int[] value) {
        this.add(name, new IntArrayTagImpl(value));
    }

    @Override
    public void add(String name, long[] value) {
        this.add(name, new LongArrayTagImpl(value));
    }

    @Override
    public void add(String name, Number number) {
        Number number2 = number;
        Objects.requireNonNull(number2);
        Number number3 = number2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Float.class, Short.class, Long.class, Byte.class}, (Object)number3, n)) {
            case 0: {
                Integer value = (Integer)number3;
                this.add(name, IntTag.of(value));
                break;
            }
            case 1: {
                Float value = (Float)number3;
                this.add(name, FloatTag.of(value.floatValue()));
                break;
            }
            case 2: {
                Short value = (Short)number3;
                this.add(name, ShortTag.of(value));
                break;
            }
            case 3: {
                Long value = (Long)number3;
                this.add(name, LongTag.of(value));
                break;
            }
            case 4: {
                Byte value = (Byte)number3;
                this.add(name, ByteTag.of(value));
                break;
            }
            default: {
                this.add(name, DoubleTag.of(number.doubleValue()));
            }
        }
    }

    @Override
    public void add(String name, Boolean value) {
        this.add(name, ByteTag.of(value != false ? (byte)1 : 0));
    }

    @Override
    public void addAll(CompoundTag tag) {
        tag.forEach(this::add);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Tag> action) {
        ((Map)this.getValue()).forEach(action);
    }

    @Override
    public Set<Map.Entry<String, Tag>> entrySet() {
        return ((Map)this.getValue()).entrySet();
    }

    @Override
    public Set<String> keySet() {
        return ((Map)this.getValue()).keySet();
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.getValue()).isEmpty();
    }

    @Override
    public int size() {
        return ((Map)this.getValue()).size();
    }

    @Override
    public boolean containsKey(String property) {
        return ((Map)this.getValue()).containsKey(property);
    }

    @Override
    @NullUnmarked
    public <T extends Tag> T get(String property) {
        return (T)((Tag)((Map)this.getValue()).get(property));
    }

    @Override
    public <E extends Tag> ListTag<E> getAsList(String tag) {
        return this.get(tag).getAsList();
    }

    @Override
    public CompoundTag getAsCompound(String tag) {
        return this.get(tag).getAsCompound();
    }

    @Override
    public <T extends Tag> T getOrAdd(String tag, T defaultValue) {
        T value = this.get(tag);
        if (value != null) {
            return value;
        }
        this.add(tag, defaultValue);
        return defaultValue;
    }

    @Override
    @NullUnmarked
    public <T extends Tag> T getOrDefault(String tag, T defaultValue) {
        return ((Map)this.getValue()).getOrDefault(tag, defaultValue);
    }

    @Override
    public <T extends Tag> Optional<T> optional(String tag) {
        return Optional.ofNullable(this.get(tag)).map(value -> (Tag)value);
    }

    @Override
    public CompoundTag.Builder toBuilder() {
        return new Builder().putAll(this);
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        for (Map.Entry<String, Tag> entry : this.entrySet()) {
            outputStream.writeTag(entry.getKey(), entry.getValue());
        }
        EscapeTagImpl.INSTANCE.write(outputStream);
    }

    public static CompoundTag read(NBTInputStream inputStream) throws IOException {
        Map.Entry<Tag, Optional<String>> entry;
        HashMap<String, Tag> value = new HashMap<String, Tag>();
        while (!(entry = inputStream.readNamedTag()).getValue().isEmpty()) {
            value.put(entry.getValue().get(), entry.getKey());
        }
        return new CompoundTagImpl((Map<String, Tag>)value);
    }

    public static CompoundTag.Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements CompoundTag.Builder {
        private final Map<String, Tag> values = new HashMap<String, Tag>();

        @Override
        public Builder put(String name, Boolean value) {
            return this.put(name, new ByteTagImpl(value != false ? (byte)1 : 0));
        }

        @Override
        public Builder put(String name, byte ... array) {
            return this.put(name, new ByteArrayTagImpl(array));
        }

        @Override
        public Builder put(String name, int ... array) {
            return this.put(name, new IntArrayTagImpl(array));
        }

        @Override
        public Builder put(String name, long ... array) {
            return this.put(name, new LongArrayTagImpl(array));
        }

        @Override
        public Builder put(String name, Number number) {
            Number number2 = number;
            Objects.requireNonNull(number2);
            Number number3 = number2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Float.class, Short.class, Long.class, Byte.class}, (Object)number3, n)) {
                case 0 -> {
                    Integer value = (Integer)number3;
                    yield this.put(name, new IntTagImpl(value));
                }
                case 1 -> {
                    Float value = (Float)number3;
                    yield this.put(name, new FloatTagImpl(value));
                }
                case 2 -> {
                    Short value = (Short)number3;
                    yield this.put(name, new ShortTagImpl(value));
                }
                case 3 -> {
                    Long value = (Long)number3;
                    yield this.put(name, LongTag.of(value));
                }
                case 4 -> {
                    Byte value = (Byte)number3;
                    yield this.put(name, ByteTag.of(value));
                }
                default -> this.put(name, new DoubleTagImpl(number.doubleValue()));
            };
        }

        @Override
        public Builder put(String name, String value) {
            return this.put(name, new StringTagImpl(value));
        }

        @Override
        public Builder put(String name, Tag tag) {
            this.values.put(name, tag);
            return this;
        }

        @Override
        public Builder putAll(CompoundTag tag) {
            this.values.putAll((Map)tag.getValue());
            return this;
        }

        @Override
        public CompoundTag build() {
            return new CompoundTagImpl((Map<String, Tag>)new HashMap<String, Tag>(this.values));
        }
    }
}

