/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.serialization.adapter;

import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.StringTag;
import net.thenextlvl.nbt.tag.Tag;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EnumAdapter<T extends Enum<T>>
implements TagAdapter<T> {
    private final Class<T> enumClass;

    public EnumAdapter(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public @NonNull T deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        return Enum.valueOf(this.enumClass, tag.getAsString());
    }

    @Override
    public Tag serialize(T object, TagSerializationContext context) throws ParserException {
        return StringTag.of(((Enum)object).name());
    }
}

