/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.listener;

import net.kyori.adventure.audience.Audience;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;

public final class EntityListener
implements Listener {
    private final ProtectPlugin plugin;

    public EntityListener(ProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Area area = this.plugin.areaProvider().getArea((Entity)player);
        if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.KILL)) {
            return;
        }
        event.setCancelled(area.getFlag(this.plugin.flags.damage) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        if (event.getAttacker() == null) {
            return;
        }
        event.setCancelled(!this.plugin.protectionService().canAttack(event.getAttacker(), (Entity)event.getVehicle()));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntitySpawn(EntitySpawnEvent event) {
        if (!event.getEntity().getEntitySpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL)) {
            return;
        }
        Area area = this.plugin.areaProvider().getArea(event.getEntity());
        event.setCancelled(area.getFlag(this.plugin.flags.naturalEntitySpawn) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        Area area = this.plugin.areaProvider().getArea((Entity)event.getEntity());
        event.setCancelled(event.getItem() == null && area.getFlag(this.plugin.flags.hunger) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        event.setCancelled(!this.plugin.protectionService().canAttack(event.getEntity(), event.getTarget()));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Area area = this.plugin.areaProvider().getArea(event.getEntity());
        event.setCancelled(!this.plugin.protectionService().canAttack(event.getDamager(), event.getEntity()));
        this.plugin.failed((Audience)event.getDamager(), (Cancellable)event, area, "area.failed.attack");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInteract(PlayerInteractEntityEvent event) {
        event.setCancelled(!this.plugin.protectionService().canInteract((Entity)event.getPlayer(), event.getRightClicked()));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea(event.getRightClicked()), "area.failed.interact");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        event.setCancelled(!this.plugin.protectionService().canShear((Entity)event.getPlayer(), event.getEntity()));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea(event.getEntity()), "area.failed.interact");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        Area area = this.plugin.areaProvider().getArea((Entity)event.getEntity());
        event.setCancelled(!this.plugin.protectionService().canAttack(event.getRemover(), (Entity)event.getEntity()));
        this.plugin.failed((Audience)event.getRemover(), area, "area.failed.attack");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        Area area = this.plugin.areaProvider().getArea((Entity)event.getEntity());
        event.setCancelled(!this.plugin.protectionService().canPlace((Entity)event.getPlayer(), area));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, area, "area.failed.place");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityPlace(EntityPlaceEvent event) {
        Area area = this.plugin.areaProvider().getArea(event.getEntity());
        event.setCancelled(!this.plugin.protectionService().canPlace((Entity)event.getPlayer(), area));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, area, "area.failed.place");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        event.setCancelled(!this.plugin.protectionService().canInteract((Entity)event.getPlayer(), (Entity)event.getRightClicked()));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea((Entity)event.getRightClicked()), "area.failed.interact");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDrop(EntityDropItemEvent event) {
        Area area = this.plugin.areaProvider().getArea(event.getEntity());
        event.setCancelled(area.getFlag(this.plugin.flags.entityItemDrop) == false);
        this.plugin.failed((Audience)event.getEntity(), (Cancellable)event, area, "area.failed.drop");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDrop(PlayerDropItemEvent event) {
        Area area = this.plugin.areaProvider().getArea((Entity)event.getPlayer());
        event.setCancelled(area.getFlag(this.plugin.flags.playerItemDrop) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPickup(EntityPickupItemEvent event) {
        Area area = this.plugin.areaProvider().getArea((Entity)event.getItem());
        event.setCancelled(area.getFlag(this.plugin.flags.entityItemPickup) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Area area = this.plugin.areaProvider().getArea((Entity)event.getEntity());
        event.setCancelled(area.getFlag(this.plugin.flags.shoot) == false);
        this.plugin.failed((Audience)event.getEntity(), (Cancellable)event, area, "area.failed.shoot");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityBreakDoor(EntityBreakDoorEvent event) {
        Area area = this.plugin.areaProvider().getArea((Entity)event.getEntity());
        event.setCancelled(area.getFlag(this.plugin.flags.entityBreakDoor) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSheepEatGrass(EntityChangeBlockEvent event) {
        if (!event.getEntityType().equals((Object)EntityType.SHEEP)) {
            return;
        }
        Area area = this.plugin.areaProvider().getArea(event.getEntity());
        event.setCancelled(area.getFlag(this.plugin.flags.sheepEatGrass) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (!event.getEntityType().equals((Object)EntityType.FALLING_BLOCK)) {
            return;
        }
        if (event.getTo().isAir()) {
            return;
        }
        Location origin = event.getEntity().getOrigin();
        Area from = origin != null ? this.plugin.areaProvider().getArea(origin) : null;
        Area area = this.plugin.areaProvider().getArea(event.getEntity());
        if (from != null && from.canInteract(area)) {
            return;
        }
        event.setCancelled(true);
    }
}

