/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.mask;

import com.fastasyncworldedit.bukkit.regions.BukkitMaskManager;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.regions.FaweMask;
import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.world.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.GlobalArea;
import net.thenextlvl.protect.area.RegionizedArea;
import org.bukkit.entity.Entity;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ProtectMaskManager
extends BukkitMaskManager {
    private static final CuboidRegion GLOBAL = new CuboidRegion(BlockVector3.at((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE), BlockVector3.at((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
    private final ProtectPlugin plugin;

    public ProtectMaskManager(ProtectPlugin plugin) {
        super(plugin.getName());
        this.plugin = plugin;
    }

    public @Nullable FaweMask getMask(Player player, FaweMaskManager.MaskType type, boolean whitelist) {
        return this.getMask(player, type, whitelist, true);
    }

    public @Nullable FaweMask getMask(Player player, FaweMaskManager.MaskType type, boolean whitelist, boolean notify) {
        if (whitelist && Settings.settings().REGION_RESTRICTIONS_OPTIONS.WORLDGUARD_REGION_BLACKLIST) {
            return new FaweMask((Region)GLOBAL);
        }
        org.bukkit.entity.Player bukkit = this.plugin.getServer().getPlayer(player.getUniqueId());
        if (bukkit == null) {
            return null;
        }
        List<Area> areas = this.getAreas(bukkit, whitelist);
        if (areas.isEmpty()) {
            return null;
        }
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Area area : areas) {
            if (area instanceof RegionizedArea) {
                RegionizedArea regionized = (RegionizedArea)area;
                regions.add((Region)regionized.getRegion());
                continue;
            }
            if (!(area instanceof GlobalArea)) continue;
            regions.add((Region)GLOBAL);
        }
        return new RegionMask(bukkit, regions, areas, player.getWorld());
    }

    public List<Area> getAreas(org.bukkit.entity.Player player, boolean whitelist) {
        return this.plugin.areaProvider().getAreas(player.getWorld()).filter(area -> whitelist == this.plugin.protectionService().canEdit((Entity)player, (Area)area)).toList();
    }

    private final class RegionMask
    extends FaweMask {
        private final org.bukkit.entity.Player player;
        private final Collection<Area> areas;

        public RegionMask(org.bukkit.entity.Player player, Collection<Region> regions, Collection<Area> areas, World world) {
            super((Region)new RegionIntersection(world, regions));
            this.player = player;
            this.areas = areas;
        }

        public boolean isValid(Player ignored, FaweMaskManager.MaskType type) {
            return this.areas.stream().allMatch(area -> ProtectMaskManager.this.plugin.protectionService().canEdit((Entity)this.player, (Area)area));
        }
    }
}

