/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.adapter.region;

import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.regions.CylinderRegion;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CylinderRegionAdapter
implements TagAdapter<CylinderRegion> {
    @Override
    public CylinderRegion deserialize(Tag tag, TagDeserializationContext context) {
        CompoundTag compound = tag.getAsCompound();
        BlockVector3 center = context.deserialize((Tag)compound.get("center"), BlockVector3.class);
        Vector2 radius = context.deserialize((Tag)compound.get("radius"), Vector2.class);
        int max = compound.get("max").getAsInt();
        int min = compound.get("min").getAsInt();
        return new CylinderRegion(center, radius, min, max);
    }

    @Override
    public Tag serialize(CylinderRegion vector, TagSerializationContext context) {
        CompoundTag tag = CompoundTag.empty();
        tag.add("center", context.serialize(vector.getCenter().toBlockPoint()));
        tag.add("radius", context.serialize(vector.getRadius()));
        tag.add("max", vector.getMaximumY());
        tag.add("min", vector.getMinimumY());
        return tag;
    }
}

