/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.listener;

import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.flag.Flag;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Fence;
import org.bukkit.block.data.type.GlassPane;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.block.data.type.Wall;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.jspecify.annotations.Nullable;

public class PhysicsListener
implements Listener {
    private final ProtectPlugin plugin;

    public PhysicsListener(ProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPhysics(BlockPhysicsEvent event) {
        if ((event.getSourceBlock().isEmpty() && event.getChangedType().isAir() || event.getSourceBlock().getType().equals((Object)Material.SNOW) || event.getSourceBlock().getType().equals((Object)Material.POWDER_SNOW) || event.getSourceBlock().getType().equals((Object)Material.SNOW_BLOCK)) && event.getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.GRASS_BLOCK)) {
            return;
        }
        if (event.getChangedType().equals((Object)Material.IRON_BARS) || event.getChangedBlockData() instanceof Stairs || event.getChangedBlockData() instanceof Chest || event.getChangedBlockData() instanceof Fence || event.getChangedBlockData() instanceof GlassPane || event.getChangedBlockData() instanceof Wall || event.getChangedBlockData() instanceof Door) {
            return;
        }
        if (event.getChangedBlockData() instanceof Powerable && !event.getBlock().isEmpty()) {
            return;
        }
        event.setCancelled(this.isInteractionRestricted(event.getSourceBlock(), event.getBlock(), event.getChangedType().hasGravity() ? this.plugin.flags.gravity : this.plugin.flags.physics));
    }

    private boolean isInteractionRestricted(Block source, @Nullable Block target, Flag<Boolean> flag) {
        Area area = this.plugin.areaProvider().getArea(source);
        if (!area.getFlag(flag).booleanValue()) {
            return true;
        }
        return target != null && !source.equals((Object)target) && !area.canInteract(this.plugin.areaProvider().getArea(target));
    }
}

