/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.flag;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.thenextlvl.protect.flag.CraftFlag;
import net.thenextlvl.protect.flag.CraftProtectionFlag;
import net.thenextlvl.protect.flag.Flag;
import net.thenextlvl.protect.flag.FlagRegistry;
import net.thenextlvl.protect.flag.ProtectionFlag;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;

public class CraftFlagRegistry
implements FlagRegistry {
    private final Map<Plugin, Set<Flag<?>>> registry = new HashMap();

    public Map<Plugin, Set<Flag<?>>> getRegistry() {
        return this.registry;
    }

    @Override
    @NullMarked
    public Set<Flag<?>> getFlags() {
        return this.registry.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    @NullMarked
    public Set<Flag<?>> getFlags(Plugin plugin) {
        return this.registry.get(plugin);
    }

    @Override
    @NullMarked
    public <T> Optional<Flag<T>> getFlag(Key key) {
        return this.getFlags().stream().filter(flag -> flag.key().equals((Object)key)).map(flag -> flag).findAny();
    }

    @Override
    public <T> @NonNull Flag<T> register(@NonNull Plugin plugin, @NonNull Class<? extends T> type, @KeyPattern.Value @NonNull String name, T defaultValue) throws IllegalStateException {
        return this.register(plugin, name, key -> new CraftFlag<Object>((Key)key, type, defaultValue));
    }

    @Override
    public <T> @NonNull ProtectionFlag<T> register(@NonNull Plugin plugin, @NonNull Class<? extends T> type, @KeyPattern.Value @NonNull String name, T defaultValue, T protectedValue) throws IllegalStateException {
        return this.register(plugin, name, key -> new CraftProtectionFlag<Object>((Key)key, type, defaultValue, protectedValue));
    }

    private <T extends Flag<?>> T register(@NonNull Plugin plugin, @KeyPattern.Value @NonNull String name, @NonNull Function<Key, T> function) {
        Key key = Key.key((String)plugin.getName().replace("-", "_").toLowerCase(), (String)name);
        Flag flag = (Flag)function.apply(key);
        if (this.registry.computeIfAbsent(plugin, p -> new HashSet()).add(flag)) {
            return (T)flag;
        }
        throw new IllegalStateException("Already registered flag: " + String.valueOf(key));
    }

    @Override
    public boolean unregister(@NonNull Key key) {
        for (Set<Flag<?>> flags : this.registry.values()) {
            if (!flags.removeIf(flag -> flag.key().equals((Object)key))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean unregisterAll(@NonNull Plugin plugin) {
        Set<Flag<?>> remove = this.registry.remove(plugin);
        return remove != null && !remove.isEmpty();
    }
}

