/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.RegionizedArea;
import net.thenextlvl.protect.command.argument.AreaArgumentType;
import net.thenextlvl.protect.command.argument.RegionizedAreaArgumentType;
import net.thenextlvl.protect.exception.CircularInheritanceException;
import org.bukkit.command.CommandSender;

class AreaParentCommand {
    AreaParentCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"parent").requires(stack -> stack.getSender().hasPermission("protect.command.area.parent"))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(stack -> stack.getSender().hasPermission("protect.command.area.parent.set"))).then(Commands.argument((String)"area", (ArgumentType)new RegionizedAreaArgumentType(plugin)).then(Commands.argument((String)"parent", (ArgumentType)new AreaArgumentType(plugin)).executes(context -> AreaParentCommand.set((CommandContext<CommandSourceStack>)context, plugin)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(stack -> stack.getSender().hasPermission("protect.command.area.parent.remove"))).then(Commands.argument((String)"area", (ArgumentType)new AreaArgumentType(plugin, (commandContext, area) -> area.getParent().isPresent())).executes(context -> AreaParentCommand.remove((CommandContext<CommandSourceStack>)context, plugin))));
    }

    private static int set(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        try {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            RegionizedArea area = (RegionizedArea)context.getArgument("area", RegionizedArea.class);
            Area parent = (Area)context.getArgument("parent", Area.class);
            boolean success = area.setParent(parent);
            String message = success ? "area.parent.set" : "nothing.changed";
            plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"area", (String)area.getName()), Placeholder.parsed((String)"parent", (String)parent.getName())});
            return 1;
        }
        catch (CircularInheritanceException e) {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            plugin.bundle().sendMessage((Audience)sender, "area.parent.circular-inheritance");
            return 0;
        }
    }

    private static int remove(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        RegionizedArea area = (RegionizedArea)context.getArgument("area", RegionizedArea.class);
        boolean success = area.setParent(null);
        String message = success ? "area.parent.remove" : "nothing.changed";
        plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"area", (String)area.getName())});
        return 1;
    }
}

