/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.GroupedArea;
import net.thenextlvl.protect.area.RegionizedArea;
import net.thenextlvl.protect.command.argument.GroupedAreaArgumentType;
import net.thenextlvl.protect.command.argument.RegionizedAreaArgumentType;
import net.thenextlvl.protect.region.GroupedRegion;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class AreaGroupCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"group").requires(stack -> stack.getSender().hasPermission("protect.command.area.group"))).then(AreaGroupCommand.add(plugin))).then(AreaGroupCommand.delete(plugin))).then(AreaGroupCommand.groupCreate(plugin))).then(AreaGroupCommand.list(plugin))).then(AreaGroupCommand.redefine(plugin))).then(AreaGroupCommand.remove(plugin))).then(AreaGroupCommand.select(plugin));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> add(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").requires(stack -> stack.getSender().hasPermission("protect.command.area.group.add"))).then(((RequiredArgumentBuilder)Commands.argument((String)"group", (ArgumentType)new GroupedAreaArgumentType(plugin)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = (String)context.getArgument("name", String.class);
            return AreaGroupCommand.add((CommandContext<CommandSourceStack>)context, name, plugin);
        }))).executes(context -> {
            GroupedArea group = (GroupedArea)context.getArgument("group", GroupedArea.class);
            String name = "region-" + (((GroupedRegion)((Object)((Object)group.getRegion()))).getRegions().size() + 1);
            return AreaGroupCommand.add((CommandContext<CommandSourceStack>)context, name, plugin);
        }));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> delete(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(stack -> stack.getSender().hasPermission("protect.command.area.group.delete"))).then(Commands.argument((String)"group", (ArgumentType)new GroupedAreaArgumentType(plugin)).executes(context -> AreaGroupCommand.delete((CommandContext<CommandSourceStack>)context, plugin)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> groupCreate(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"create").requires(stack -> stack.getSender().hasPermission("protect.command.area.group.create"))).then(Commands.argument((String)"area", (ArgumentType)new RegionizedAreaArgumentType(plugin, regionizedArea -> !(regionizedArea instanceof GroupedArea))).executes(context -> AreaGroupCommand.create((CommandContext<CommandSourceStack>)context, plugin)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> list(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(stack -> stack.getSender().hasPermission("protect.command.area.group.list"))).then(Commands.argument((String)"group", (ArgumentType)new GroupedAreaArgumentType(plugin)).executes(context -> AreaGroupCommand.list((CommandContext<CommandSourceStack>)context, plugin)))).executes(context -> AreaGroupCommand.listAll((CommandContext<CommandSourceStack>)context, plugin));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> redefine(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"redefine").requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("protect.command.area.group.redefine");
        })).then(Commands.argument((String)"group", (ArgumentType)new GroupedAreaArgumentType(plugin)).then(Commands.argument((String)"region", (ArgumentType)StringArgumentType.string()).suggests(AreaGroupCommand.suggestGroups(plugin)).executes(context -> AreaGroupCommand.redefine((CommandContext<CommandSourceStack>)context, plugin))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> remove(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(stack -> stack.getSender().hasPermission("protect.command.area.group.remove"))).then(Commands.argument((String)"group", (ArgumentType)new GroupedAreaArgumentType(plugin)).then(Commands.argument((String)"region", (ArgumentType)StringArgumentType.string()).suggests(AreaGroupCommand.suggestGroups(plugin)).executes(context -> AreaGroupCommand.remove((CommandContext<CommandSourceStack>)context, plugin))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> select(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"select").requires(stack -> stack.getSender().hasPermission("worldedit.selection.pos"))).then(Commands.argument((String)"group", (ArgumentType)new GroupedAreaArgumentType(plugin)).then(Commands.argument((String)"region", (ArgumentType)StringArgumentType.string()).suggests(AreaGroupCommand.suggestGroups(plugin)).executes(context -> AreaGroupCommand.select((CommandContext<CommandSourceStack>)context, plugin))));
    }

    private static SuggestionProvider<CommandSourceStack> suggestGroups(ProtectPlugin plugin) {
        return (context, builder) -> {
            GroupedArea group = (GroupedArea)context.getChild().getArgument("group", GroupedArea.class);
            ((GroupedRegion)((Object)((Object)group.getRegion()))).getRegions().keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        };
    }

    private static int remove(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        GroupedArea group = (GroupedArea)context.getArgument("group", GroupedArea.class);
        String region = (String)context.getArgument("region", String.class);
        boolean success = ((GroupedRegion)((Object)group.getRegion())).removeRegion(region);
        String message = success ? "area.group.remove" : "nothing.changed";
        plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"area", (String)group.getName()), Placeholder.parsed((String)"region", (String)region)});
        return success ? 1 : 0;
    }

    private static int list(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        GroupedArea group = (GroupedArea)context.getArgument("group", GroupedArea.class);
        List<TextComponent> regions = ((GroupedRegion)((Object)group.getRegion())).getRegions().keySet().stream().map(Component::text).toList();
        plugin.bundle().sendMessage((Audience)sender, "area.list.regions", new TagResolver[]{Formatter.number((String)"amount", (Number)regions.size()), Placeholder.parsed((String)"group", (String)group.getName()), Formatter.joining((String)"regions", regions)});
        return 1;
    }

    private static int listAll(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        List<TextComponent> groups = plugin.areaProvider().getAreas().filter(GroupedArea.class::isInstance).map(Area::getName).map(Component::text).toList();
        plugin.bundle().sendMessage((Audience)sender, "area.list.groups", Formatter.number((String)"amount", (Number)groups.size()), Formatter.joining((String)"groups", groups));
        return 1;
    }

    private static int redefine(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        GroupedArea group = (GroupedArea)context.getArgument("group", GroupedArea.class);
        String name = (String)context.getArgument("region", String.class);
        try {
            String message;
            WorldEditPlugin worldEdit = (WorldEditPlugin)JavaPlugin.getPlugin(WorldEditPlugin.class);
            Region region = worldEdit.getSession(player).getSelection();
            boolean redefine = region.getClass().isInstance(((GroupedRegion)((Object)group.getRegion())).getRegion(name));
            String string = message = redefine ? "area.redefine.success.group" : "area.redefine.unsupported";
            if (redefine) {
                ((GroupedRegion)((Object)group.getRegion())).setRegion(name, region);
            }
            plugin.bundle().sendMessage((Audience)player, message, new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName()), Placeholder.parsed((String)"region", (String)name), Placeholder.parsed((String)"type", (String)region.getClass().getSimpleName())});
            return redefine ? 1 : 0;
        }
        catch (IncompleteRegionException e) {
            plugin.bundle().sendMessage((Audience)player, "region.select");
            return 0;
        }
    }

    private static int add(CommandContext<CommandSourceStack> context, String name, ProtectPlugin plugin) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        try {
            LocalSession session = WorldEditPlugin.getInstance().getSession(player);
            Region region = session.getSelection();
            GroupedArea group = (GroupedArea)context.getArgument("group", GroupedArea.class);
            if (!((GroupedRegion)((Object)group.getRegion())).getRegions().values().iterator().next().getClass().isInstance(region)) {
                plugin.bundle().sendMessage((Audience)player, "region.unsupported", new TagResolver[]{Placeholder.parsed((String)"type", (String)region.getClass().getSimpleName())});
                return 0;
            }
            boolean success = !((GroupedRegion)((Object)group.getRegion())).hasRegion(region) && ((GroupedRegion)((Object)group.getRegion())).addRegion(name, region);
            String message = success ? "area.group.add" : "nothing.changed";
            plugin.bundle().sendMessage((Audience)player, message, new TagResolver[]{Placeholder.parsed((String)"area", (String)group.getName()), Placeholder.parsed((String)"region", (String)name)});
            return success ? 1 : 0;
        }
        catch (IncompleteRegionException ignored) {
            plugin.bundle().sendMessage((Audience)player, "region.select");
            return 0;
        }
    }

    private static int delete(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        GroupedArea group = (GroupedArea)context.getArgument("group", GroupedArea.class);
        if (!plugin.areaService().delete(group)) {
            plugin.bundle().sendMessage((Audience)sender, "area.group.delete.failed", new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName())});
            return 0;
        }
        try {
            Region region = ((GroupedRegion)((Object)group.getRegion())).getRegions().values().iterator().next();
            RegionizedArea<Region> area = plugin.areaService().creator(group).region(region).create();
            plugin.bundle().sendMessage((Audience)sender, "area.group.delete", new TagResolver[]{Placeholder.parsed((String)"group", (String)area.getName())});
            return 1;
        }
        catch (Exception e) {
            plugin.getComponentLogger().error("Failed to create grouped area", (Throwable)e);
            if (sender instanceof ConsoleCommandSender) {
                return 0;
            }
            plugin.bundle().sendMessage((Audience)sender, "command.error");
            return 0;
        }
    }

    private static int create(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        RegionizedArea area = (RegionizedArea)context.getArgument("area", RegionizedArea.class);
        if (!plugin.areaService().delete(area)) {
            plugin.bundle().sendMessage((Audience)sender, "area.group.create.failed", new TagResolver[]{Placeholder.parsed((String)"area", (String)area.getName())});
            return 0;
        }
        try {
            RegionizedArea<GroupedRegion> grouped = plugin.areaService().creator(area).region(new GroupedRegion(Map.of("root", area.getRegion()))).create();
            plugin.bundle().sendMessage((Audience)sender, "area.group.create", new TagResolver[]{Placeholder.parsed((String)"area", (String)grouped.getName())});
            return 1;
        }
        catch (Exception e) {
            plugin.getComponentLogger().error("Failed to create grouped area", (Throwable)e);
            if (sender instanceof ConsoleCommandSender) {
                return 0;
            }
            plugin.bundle().sendMessage((Audience)sender, "command.error");
            return 0;
        }
    }

    private static int select(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        GroupedArea group = (GroupedArea)context.getArgument("group", GroupedArea.class);
        String name = (String)context.getArgument("region", String.class);
        Region region = ((GroupedRegion)((Object)group.getRegion())).getRegion(name);
        if (region == null) {
            plugin.bundle().sendMessage((Audience)player, "area.group.region.unknown", new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName()), Placeholder.parsed((String)"region", (String)name)});
            return 0;
        }
        LocalSession session = WorldEditPlugin.getInstance().getSession(player);
        CuboidRegionSelector selector = new CuboidRegionSelector(null, region.getMinimumPoint(), region.getMaximumPoint());
        session.setRegionSelector(BukkitAdapter.adapt((World)group.getWorld()), (RegionSelector)selector);
        session.updateServerCUI((Actor)BukkitAdapter.adapt((Player)player));
        plugin.bundle().sendMessage((Audience)player, "area.select.group", new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName()), Placeholder.parsed((String)"region", (String)name)});
        return 1;
    }
}

