/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.regions.Region;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.RegionizedArea;
import net.thenextlvl.protect.exception.UnsupportedRegionException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class AreaCreateCommand {
    AreaCreateCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"create").requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("protect.command.area.create");
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"priority", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Integer priority = (Integer)context.getArgument("priority", Integer.TYPE);
            return AreaCreateCommand.execute((CommandContext<CommandSourceStack>)context, priority, plugin);
        }))).executes(context -> AreaCreateCommand.execute((CommandContext<CommandSourceStack>)context, 0, plugin)));
    }

    private static int execute(CommandContext<CommandSourceStack> context, int priority, ProtectPlugin plugin) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        String name = (String)context.getArgument("name", String.class);
        if (plugin.areaProvider().getArea(name).isPresent()) {
            plugin.bundle().sendMessage((Audience)player, "area.exists", new TagResolver[]{Placeholder.parsed((String)"area", (String)name)});
            return 0;
        }
        try {
            LocalSession session = WorldEditPlugin.getInstance().getSession(player);
            RegionizedArea<Region> creator = plugin.areaService().creator(name, player.getWorld(), session.getSelection()).priority(priority).create();
            plugin.bundle().sendMessage((Audience)player, "area.created", new TagResolver[]{Placeholder.parsed((String)"area", (String)creator.getName())});
            return 1;
        }
        catch (UnsupportedRegionException e) {
            plugin.bundle().sendMessage((Audience)player, "region.unsupported", new TagResolver[]{Placeholder.parsed((String)"type", (String)e.getType().getSimpleName())});
            return 0;
        }
        catch (IncompleteRegionException ignored) {
            plugin.bundle().sendMessage((Audience)player, "region.select");
            return 0;
        }
        catch (Exception e) {
            plugin.bundle().sendMessage((Audience)player, "command.error");
            return 0;
        }
    }
}

