/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.area;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.regions.Region;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.AreaCreator;
import net.thenextlvl.protect.area.AreaService;
import net.thenextlvl.protect.area.CraftAreaCreator;
import net.thenextlvl.protect.area.RegionizedArea;
import net.thenextlvl.protect.area.event.AreaDeleteEvent;
import net.thenextlvl.protect.area.event.player.PlayerAreaLeaveEvent;
import net.thenextlvl.protect.area.event.player.PlayerAreaTransitionEvent;
import net.thenextlvl.protect.io.AreaAdapter;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftAreaService
implements AreaService {
    private final Map<Class<? extends Area>, AreaAdapter<?>> adapters = new HashMap();
    private final Set<RegionWrapper<?>> wrappers = new HashSet();
    private final ProtectPlugin plugin;

    public CraftAreaService(ProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public <T extends Region> AreaCreator<T> creator(String name, World world, T region) {
        return new CraftAreaCreator<T>(this.plugin, name, world, region);
    }

    @Override
    public <T extends Region> AreaCreator<T> creator(RegionizedArea<T> area) {
        return new CraftAreaCreator<T>(this.plugin, area.getName(), area.getWorld(), area.getRegion(), area.getParent().map(Area::getName).orElse(null), area.getOwner().orElse(null), area.getFlags(), area.getMembers(), area.getPriority());
    }

    @Override
    public <T extends Region> boolean delete(RegionizedArea<T> area) {
        if (!new AreaDeleteEvent(area).callEvent()) {
            return false;
        }
        boolean remove = this.plugin.areaProvider().delete(area);
        if (remove) {
            this.handlePostRemove(area);
        }
        return remove;
    }

    @Override
    public <T extends Region> Optional<Function<AreaCreator<T>, RegionizedArea<T>>> getWrapper(Class<T> type) {
        return this.wrappers.stream().filter(wrapper -> wrapper.type().isAssignableFrom(type)).map(wrapper -> wrapper).map(RegionWrapper::creator).findFirst();
    }

    @Override
    public <T extends Region> boolean unregisterWrapper(Class<T> type) {
        return this.wrappers.removeIf(wrapper -> wrapper.type().isAssignableFrom(type));
    }

    @Override
    public <T extends Region> void registerWrapper(Class<T> type, Function<AreaCreator<T>, RegionizedArea<T>> creator) throws IllegalStateException {
        RegionWrapper<T> wrapper = new RegionWrapper<T>(type, creator);
        Preconditions.checkState((boolean)this.wrappers.add(wrapper), (Object)("Duplicate wrapper for type: " + type.getName()));
    }

    @Override
    public Set<Class<? extends Region>> getRegionWrappers() {
        return this.wrappers.stream().map(RegionWrapper::type).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Map<Class<? extends Area>, AreaAdapter<?>> getAdapters() {
        return Map.copyOf(this.adapters);
    }

    @Override
    public <T extends Area> void registerAdapter(Class<T> type, AreaAdapter<T> adapter) throws IllegalStateException {
        Preconditions.checkState((!this.adapters.containsKey(type) ? 1 : 0) != 0, (Object)("Duplicate adapter for type: " + type.getName()));
        Preconditions.checkState((boolean)this.adapters.values().stream().filter(value -> value.key().equals((Object)adapter.key())).findAny().isEmpty(), (Object)("Duplicate key for adapter: " + String.valueOf(adapter.key()) + " in " + adapter.getClass().getName()));
        this.adapters.put(type, adapter);
    }

    @Override
    public <T extends Area> boolean unregisterAdapter(Class<T> type) {
        return this.adapters.remove(type) != null;
    }

    @Override
    public <T extends Area> AreaAdapter<T> getAdapter(Class<T> type) throws NullPointerException {
        return Objects.requireNonNull(this.adapters.get(type), "No adapter for type: " + type.getName());
    }

    @Override
    public <T extends Area> AreaAdapter<T> getAdapter(Key key) throws IllegalArgumentException {
        return this.adapters.values().stream().filter(adapter -> adapter.key().equals((Object)key)).findAny().orElseThrow(() -> new IllegalArgumentException("No adapter for key: " + String.valueOf(key)));
    }

    private void handlePostRemove(Area removed) {
        removed.getPlayers().forEach(player -> {
            new PlayerAreaLeaveEvent((Player)player, removed).callEvent();
            Area target = this.plugin.areaProvider().getArea((Entity)player);
            if (removed.getPriority() < target.getPriority()) {
                return;
            }
            new PlayerAreaTransitionEvent((Player)player, removed, target).callEvent();
        });
    }

    private record RegionWrapper<T extends Region>(Class<T> type, Function<AreaCreator<T>, RegionizedArea<T>> creator) {
    }
}

