/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.area;

import core.io.IO;
import core.io.PathIO;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.AreaProvider;
import net.thenextlvl.protect.area.CraftGlobalArea;
import net.thenextlvl.protect.area.GlobalArea;
import net.thenextlvl.protect.area.event.AreaLoadEvent;
import org.bukkit.Location;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftAreaProvider
implements AreaProvider {
    private static final String ISSUES = "https://github.com/TheNextLvl-net/protect/issues/new";
    private final Map<World, Set<Area>> areas = new HashMap<World, Set<Area>>();
    private final ProtectPlugin plugin;

    public CraftAreaProvider(ProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Stream<Area> getAreas() {
        return this.areas.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Stream<Area> getAreas(World world) {
        return this.areas.getOrDefault(world, Collections.emptySet()).stream();
    }

    @Override
    public Stream<Area> getAreas(Location location) {
        return this.getAreas(location.getWorld()).filter(area -> area.contains(location));
    }

    @Override
    public Area getArea(Location location) {
        return this.getAreas(location).max(Comparator.comparingInt(Area::getPriority)).orElseGet(() -> this.getArea(location.getWorld()));
    }

    @Override
    public Optional<Area> getArea(String name) {
        return this.getAreas().filter(area -> area.getName().equals(name)).findAny();
    }

    @Override
    public GlobalArea getArea(World world) {
        return this.getAreas(world).filter(area -> area instanceof GlobalArea).map(area -> (GlobalArea)area).findAny().orElseThrow(() -> new IllegalStateException("No global area found for " + world.key().asString()));
    }

    public void load(World world) {
        try {
            File areaFolder = new File(world.getWorldFolder(), "areas");
            File[] files = areaFolder.listFiles((file, name) -> name.endsWith(".dat"));
            if (files != null) {
                for (File file2 : files) {
                    this.load(world, file2);
                }
            }
            if (this.getAreas(world).anyMatch(area -> area instanceof GlobalArea)) {
                return;
            }
            this.persist(new CraftGlobalArea(this.plugin, world));
        }
        catch (Exception e) {
            this.plugin.getComponentLogger().error("Failed to load areas for {}", (Object)world.key().asString(), (Object)e);
        }
    }

    private void load(World world, File file) {
        try {
            Area loaded = this.read(world, null, file);
            new AreaLoadEvent(loaded).callEvent();
            this.memoize(world, loaded);
        }
        catch (EOFException e) {
            this.plugin.getComponentLogger().error("The area file {} is irrecoverably broken", (Object)file.getPath());
        }
        catch (Exception e) {
            this.plugin.getComponentLogger().error("Failed to load area from {}", (Object)file.getPath(), (Object)e);
            this.plugin.getComponentLogger().error("Please report this issue on GitHub: {}", (Object)ISSUES);
        }
    }

    public void persist(Area area) throws IOException {
        this.memoize(area.getWorld(), this.read(area.getWorld(), area, area.getFile()));
    }

    private void memoize(World world, Area area) {
        Set areas = this.areas.computeIfAbsent(world, k -> new HashSet());
        areas.stream().filter((Predicate<Area>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lnet/thenextlvl/protect/area/Area;)Z)((Area)area)).findAny().ifPresentOrElse(io -> this.plugin.getComponentLogger().warn("Ignoring duplicate area {}: {}", (Object)area.getName(), (Object)area.getFile().getPath()), () -> areas.add(area));
    }

    private Area read(World world, @Nullable Area area, File file) throws IOException {
        if (area == null) {
            return this.read(file, world);
        }
        if (file.exists()) {
            return this.read(file, area);
        }
        this.save(area);
        return area;
    }

    private NBTInputStream stream(IO file) throws IOException {
        return new NBTInputStream(file.inputStream(StandardOpenOption.READ), StandardCharsets.UTF_8);
    }

    private Area read(File file, World world) throws IOException {
        Area area;
        block15: {
            NBTInputStream inputStream = this.stream(IO.of(file));
            try {
                area = this.read(world, inputStream);
                if (inputStream == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    PathIO io = IO.of(file.getPath() + "_old", new String[0]);
                    if (!io.exists(new LinkOption[0])) {
                        throw e;
                    }
                    this.plugin.getComponentLogger().warn("Failed to load area from {}", (Object)file.getPath());
                    this.plugin.getComponentLogger().warn("Falling back to {}", (Object)io);
                    try (NBTInputStream inputStream2 = this.stream(io);){
                        Area area2 = this.read(world, inputStream2);
                        return area2;
                    }
                }
            }
            inputStream.close();
        }
        return area;
    }

    private Area read(World world, NBTInputStream inputStream) throws IOException {
        Map.Entry<Tag, Optional<String>> entry = inputStream.readNamedTag();
        CompoundTag root = entry.getKey().getAsCompound();
        String name = entry.getValue().orElseThrow(() -> new ParserException("Area misses root name"));
        Key type = this.plugin.nbt.deserialize((Tag)root.get("type"), Key.class);
        return this.plugin.areaService().getAdapter(type).construct(world, name, root);
    }

    private Area read(File file, Area area) throws IOException {
        try (NBTInputStream inputStream = this.stream(IO.of(file));){
            Tag tag = inputStream.readNamedTag().getKey();
            area.deserialize(tag);
            Area area2 = area;
            return area2;
        }
    }

    public void save(World world) {
        Set<Area> areas = this.areas.get(world);
        if (areas != null) {
            areas.forEach(this::save);
        }
    }

    private void save(Area area) {
        try {
            PathIO io = IO.of(area.getFile());
            if (io.exists(new LinkOption[0])) {
                Files.move(area.getFile().toPath(), area.getFallbackFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                io.createParents(new FileAttribute[0]);
            }
            try (NBTOutputStream outputStream = new NBTOutputStream(io.outputStream(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), StandardCharsets.UTF_8);){
                outputStream.writeTag(area.getName(), area.serialize());
            }
        }
        catch (Exception e) {
            this.plugin.getComponentLogger().error("Failed to save area {}", (Object)area.getName(), (Object)e);
            this.plugin.getComponentLogger().error("Please report this issue on GitHub: {}", (Object)ISSUES);
        }
    }

    public void unload(World world) {
        this.areas.remove(world);
    }

    public boolean delete(Area area) {
        this.areas.computeIfPresent(area.getWorld(), (world, areas) -> {
            areas.remove(area);
            return areas.isEmpty() ? null : areas;
        });
        boolean d1 = area.getFile().delete();
        boolean d2 = area.getFallbackFile().delete();
        return d1 || d2;
    }
}

