/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.adapter.region;

import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.EllipsoidRegion;
import com.sk89q.worldedit.regions.Region;
import java.util.HashMap;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.protect.exception.UnsupportedRegionException;
import net.thenextlvl.protect.region.GroupedRegion;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class GroupedRegionAdapter
implements TagAdapter<GroupedRegion> {
    @Override
    public GroupedRegion deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag compound = tag.getAsCompound();
        Class<? extends Region> type = this.type(compound.get("type").getAsString());
        CompoundTag regions = compound.getAsCompound("regions");
        HashMap<String, Region> map = new HashMap<String, Region>();
        regions.forEach((name, value) -> map.put((String)name, (Region)context.deserialize((Tag)value, type)));
        return new GroupedRegion(map);
    }

    @Override
    public Tag serialize(GroupedRegion group, TagSerializationContext context) throws ParserException {
        CompoundTag tag = CompoundTag.empty();
        tag.add("type", this.type(group.getRegions().values().iterator().next().getClass()));
        CompoundTag regions = CompoundTag.empty();
        group.getRegions().forEach((name, region) -> regions.add((String)name, context.serialize(region)));
        tag.add("regions", regions);
        return tag;
    }

    public String type(Class<? extends Region> type) {
        if (type == CuboidRegion.class) {
            return "cuboid";
        }
        if (type == CylinderRegion.class) {
            return "cylinder";
        }
        if (type == EllipsoidRegion.class) {
            return "ellipsoid";
        }
        throw new UnsupportedRegionException(type);
    }

    public Class<? extends Region> type(String type) {
        return switch (type) {
            case "cuboid" -> CuboidRegion.class;
            case "ellipsoid" -> EllipsoidRegion.class;
            case "cylinder" -> CylinderRegion.class;
            default -> throw new UnsupportedRegionException(Region.class, type);
        };
    }
}

