/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.shape;

import io.papermc.paper.math.Position;
import net.thenextlvl.portals.shape.BoundingBox;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;

record SimpleBoundingBox(World world, Position minPosition, Position maxPosition) implements BoundingBox
{
    SimpleBoundingBox(World world, Position minPosition, Position maxPosition) {
        this.world = world;
        double minX = Math.min(minPosition.x(), maxPosition.x());
        double minY = Math.min(minPosition.y(), maxPosition.y());
        double minZ = Math.min(minPosition.z(), maxPosition.z());
        this.minPosition = Position.fine((double)minX, (double)minY, (double)minZ);
        double maxX = Math.max(minPosition.x(), maxPosition.x());
        double maxY = Math.max(minPosition.y(), maxPosition.y());
        double maxZ = Math.max(minPosition.z(), maxPosition.z());
        this.maxPosition = Position.fine((double)maxX, (double)maxY, (double)maxZ);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Position getMinPosition() {
        return this.minPosition;
    }

    @Override
    public Position getMaxPosition() {
        return this.maxPosition;
    }

    @Override
    public Location getCenter() {
        return new Location(this.world, (this.getMinX() + this.getMaxX()) / 2.0, (this.getMinY() + this.getMaxY()) / 2.0, (this.getMinZ() + this.getMaxZ()) / 2.0);
    }

    @Override
    public Location getMinLocation() {
        return this.minPosition.toLocation(this.world);
    }

    @Override
    public Location getMaxLocation() {
        return this.maxPosition.toLocation(this.world);
    }

    @Override
    public double getMinX() {
        return this.minPosition.x();
    }

    @Override
    public double getMinY() {
        return this.minPosition.y();
    }

    @Override
    public double getMinZ() {
        return this.minPosition.z();
    }

    @Override
    public double getMaxX() {
        return this.maxPosition.x();
    }

    @Override
    public double getMaxY() {
        return this.maxPosition.y();
    }

    @Override
    public double getMaxZ() {
        return this.maxPosition.z();
    }

    @Override
    public boolean contains(Position position) {
        return position.x() >= this.getMinX() && position.x() <= this.getMaxX() && position.y() >= this.getMinY() && position.y() <= this.getMaxY() && position.z() >= this.getMinZ() && position.z() <= this.getMaxZ();
    }

    @Override
    public boolean contains(Entity entity) {
        return entity.getWorld().equals((Object)this.world) && this.overlaps(entity.getBoundingBox());
    }

    @Override
    public boolean intersects(BoundingBox boundingBox) {
        return this.world.equals((Object)boundingBox.getWorld()) && this.getMinX() <= boundingBox.getMaxX() && this.getMaxX() >= boundingBox.getMinX() && this.getMinY() <= boundingBox.getMaxY() && this.getMaxY() >= boundingBox.getMinY() && this.getMinZ() <= boundingBox.getMaxZ() && this.getMaxZ() >= boundingBox.getMinZ();
    }

    @Override
    public boolean overlaps(org.bukkit.util.BoundingBox boundingBox) {
        return boundingBox.overlaps(this.minPosition().toVector(), this.maxPosition().toVector());
    }
}

