/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.shape;

import io.papermc.paper.math.Position;
import net.thenextlvl.portals.shape.SimpleBoundingBox;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Contract;

public sealed interface BoundingBox
permits SimpleBoundingBox {
    @Contract(pure=true)
    public World getWorld();

    @Contract(pure=true)
    public Position getMinPosition();

    @Contract(pure=true)
    public Position getMaxPosition();

    @Contract(value=" -> new", pure=true)
    public Location getCenter();

    @Contract(value=" -> new", pure=true)
    public Location getMinLocation();

    @Contract(value=" -> new", pure=true)
    public Location getMaxLocation();

    @Contract(pure=true)
    public double getMinX();

    @Contract(pure=true)
    public double getMinY();

    @Contract(pure=true)
    public double getMinZ();

    @Contract(pure=true)
    public double getMaxX();

    @Contract(pure=true)
    public double getMaxY();

    @Contract(pure=true)
    public double getMaxZ();

    @Contract(pure=true)
    public boolean contains(Position var1);

    @Contract(pure=true)
    public boolean contains(Entity var1);

    @Contract(pure=true)
    public boolean intersects(BoundingBox var1);

    @Contract(pure=true)
    public boolean overlaps(org.bukkit.util.BoundingBox var1);

    @Contract(value="_, _, _ -> new", pure=true)
    public static BoundingBox of(World world, Position min, Position max) {
        return new SimpleBoundingBox(world, min, max);
    }
}

