/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.listeners;

import java.io.EOFException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class WorldListener
implements Listener {
    private final PortalsPlugin plugin;

    public WorldListener(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldLoad(WorldLoadEvent event) {
        Path dataFolder = this.plugin.portalProvider().getDataFolder(event.getWorld());
        if (!Files.isDirectory(dataFolder, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.find(dataFolder, 1, (path, attributes) -> attributes.isRegularFile() && path.getFileName().toString().endsWith(".dat"), new FileVisitOption[0]);){
            files.forEach(path -> this.loadSafe((Path)path, event.getWorld()));
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().error("Failed to load all portals in world {}", (Object)event.getWorld().getName(), (Object)e);
            this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/portals/issues/new?template=bug_report.yml");
            PortalsPlugin.ERROR_TRACKER.trackError(e);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldSave(WorldSaveEvent event) {
        this.plugin.portalProvider().getPortals(event.getWorld()).forEach(Portal::persist);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        this.plugin.portalProvider().portals.removeIf(portal -> {
            if (portal.getWorld().equals((Object)event.getWorld())) {
                portal.persist();
                return true;
            }
            return false;
        });
    }

    private @Nullable Portal loadSafe(Path file, World world) {
        Portal portal;
        block19: {
            NBTInputStream inputStream = NBTInputStream.create(file);
            try {
                portal = this.load(inputStream, world);
                if (inputStream == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Portal portal2;
                    block20: {
                        Path backup = file.resolveSibling(String.valueOf(file.getFileName()) + "_old");
                        if (!Files.isRegularFile(backup, new LinkOption[0])) {
                            throw e;
                        }
                        this.plugin.getComponentLogger().warn("Failed to load portal from {}", (Object)file, (Object)e);
                        this.plugin.getComponentLogger().warn("Falling back to {}", (Object)backup);
                        NBTInputStream inputStream2 = NBTInputStream.create(backup);
                        try {
                            portal2 = this.load(inputStream2, world);
                            if (inputStream2 == null) break block20;
                        }
                        catch (Throwable throwable3) {
                            try {
                                if (inputStream2 != null) {
                                    try {
                                        inputStream2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                }
                                throw throwable3;
                            }
                            catch (ParserException e2) {
                                this.plugin.getComponentLogger().warn("Failed to load portal from {}: {}", (Object)file, (Object)e2.getMessage());
                                return null;
                            }
                            catch (EOFException e3) {
                                this.plugin.getComponentLogger().error("The portal file {} is irrecoverably broken", (Object)file);
                                return null;
                            }
                            catch (Exception e4) {
                                this.plugin.getComponentLogger().error("Failed to load portal from {}", (Object)file, (Object)e4);
                                this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/portals/issues/new?template=bug_report.yml");
                                PortalsPlugin.ERROR_TRACKER.trackError(e4);
                                return null;
                            }
                        }
                        inputStream2.close();
                    }
                    return portal2;
                }
            }
            inputStream.close();
        }
        return portal;
    }

    private @Nullable Portal load(NBTInputStream inputStream, World world) throws IOException {
        Portal portal = this.plugin.nbt(world).deserialize((Tag)inputStream.readTag(), Portal.class);
        if (this.plugin.portalProvider().portals.add(portal)) {
            return portal;
        }
        this.plugin.getComponentLogger().warn("A portal with the name '{}' is already loaded", (Object)portal.getName());
        return null;
    }
}

