/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.listeners;

import io.papermc.paper.math.Position;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EntityListener
implements Listener {
    private final PortalsPlugin plugin;

    public EntityListener(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByBlock(EntityDamageByBlockEvent event) {
        if (event.getDamager() == null) {
            return;
        }
        Location location = event.getDamager().getLocation();
        event.setCancelled(this.plugin.portalProvider().getPortals(location.getWorld()).anyMatch(portal -> portal.getBoundingBox().contains((Position)location)));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByBlock(EntityCombustByBlockEvent event) {
        if (event.getCombuster() == null) {
            return;
        }
        Location location = event.getCombuster().getLocation();
        event.setCancelled(this.plugin.portalProvider().getPortals(location.getWorld()).anyMatch(portal -> portal.getBoundingBox().contains((Position)location)));
    }
}

