/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.notification;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.thenextlvl.portals.notification.NotificationType;
import net.thenextlvl.portals.notification.NotificationTypeRegistry;
import org.jetbrains.annotations.Unmodifiable;

final class SimpleNotificationTypeRegistry
implements NotificationTypeRegistry {
    public static final SimpleNotificationTypeRegistry INSTANCE = new SimpleNotificationTypeRegistry();
    private final Set<NotificationType<?>> types = new HashSet<NotificationType<String>>(Set.of(NotificationType.sound(), NotificationType.message(), NotificationType.title(), NotificationType.actionbar()));

    SimpleNotificationTypeRegistry() {
    }

    @Override
    public boolean register(NotificationType<?> type) {
        return this.types.add(type);
    }

    @Override
    public boolean isRegistered(NotificationType<?> type) {
        return this.types.contains(type);
    }

    @Override
    public boolean isRegistered(String name) {
        return this.types.stream().anyMatch(type -> type.getName().equals(name));
    }

    @Override
    public boolean unregister(NotificationType<?> type) {
        return this.types.remove(type);
    }

    @Override
    public <T> Optional<NotificationType<T>> getByName(String name) {
        return this.types.stream().filter(type -> type.getName().equals(name)).map(type -> type).findAny();
    }

    @Override
    public @Unmodifiable Set<NotificationType<?>> getNotificationTypes() {
        return Set.copyOf(this.types);
    }
}

