/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.notification;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.thenextlvl.portals.notification.NotificationTrigger;
import net.thenextlvl.portals.notification.NotificationTriggerRegistry;
import org.jetbrains.annotations.Unmodifiable;

final class SimpleNotificationTriggerRegistry
implements NotificationTriggerRegistry {
    public static final SimpleNotificationTriggerRegistry INSTANCE = new SimpleNotificationTriggerRegistry();
    private final Set<NotificationTrigger> triggers = new HashSet<NotificationTrigger>(Set.of(NotificationTrigger.teleportSuccess(), NotificationTrigger.teleportFailure(), NotificationTrigger.warmupSuccess(), NotificationTrigger.warmupFailure(), NotificationTrigger.entrySuccess(), NotificationTrigger.entryFailure(), NotificationTrigger.exit()));

    SimpleNotificationTriggerRegistry() {
    }

    @Override
    public boolean register(NotificationTrigger trigger) {
        return this.triggers.add(trigger);
    }

    @Override
    public boolean isRegistered(NotificationTrigger trigger) {
        return this.triggers.contains(trigger);
    }

    @Override
    public boolean isRegistered(String name) {
        return this.triggers.stream().anyMatch(trigger -> trigger.getName().equals(name));
    }

    @Override
    public boolean unregister(NotificationTrigger trigger) {
        return this.triggers.remove(trigger);
    }

    @Override
    public Optional<NotificationTrigger> getByName(String name) {
        return this.triggers.stream().filter(trigger -> trigger.getName().equals(name)).findAny();
    }

    @Override
    public @Unmodifiable Set<NotificationTrigger> getTriggers() {
        return Set.copyOf(this.triggers);
    }
}

