/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.notification;

import net.kyori.adventure.key.KeyPattern;
import net.kyori.adventure.sound.Sound;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.notification.SimpleNotificationType;
import net.thenextlvl.portals.view.UnparsedTitle;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Contract;

public sealed interface NotificationType<T>
permits SimpleNotificationType {
    @Contract(pure=true)
    public static NotificationType<Sound> sound() {
        return SimpleNotificationType.PLAY_SOUND;
    }

    @Contract(pure=true)
    public static NotificationType<String> message() {
        return SimpleNotificationType.MESSAGE;
    }

    @Contract(pure=true)
    public static NotificationType<UnparsedTitle> title() {
        return SimpleNotificationType.TITLE;
    }

    @Contract(pure=true)
    public static NotificationType<String> actionbar() {
        return SimpleNotificationType.ACTIONBAR;
    }

    @Contract(pure=true)
    public Class<T> getType();

    @KeyPattern.Value
    @Contract(pure=true)
    public String getName();

    @Contract(pure=true)
    public Sender<T> getSender();

    @Contract(value="_, _, _ -> new", pure=true)
    public static <T> NotificationType<T> create(@KeyPattern.Value String name, Class<T> type, Sender<T> sender) {
        return new SimpleNotificationType<T>(name, type, sender);
    }

    @FunctionalInterface
    public static interface Sender<T> {
        public void send(Entity var1, Portal var2, T var3);
    }
}

