/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.binder;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.thenextlvl.binder.StaticBinder;

final class SimpleStaticBinder
implements StaticBinder {
    private static final Map<ClassLoader, SimpleStaticBinder> INSTANCES = new ConcurrentHashMap<ClassLoader, SimpleStaticBinder>();
    private final Map<Class<?>, WeakReference<Object>> bindings = new ConcurrentHashMap();
    private final ClassLoader loader;

    public static SimpleStaticBinder getInstance(ClassLoader loader) {
        return INSTANCES.computeIfAbsent(loader, SimpleStaticBinder::new);
    }

    private SimpleStaticBinder(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public <T> void bind(Class<T> clazz, T instance) throws IllegalArgumentException, SecurityException {
        WeakReference<Object> reference = this.bindings.get(clazz);
        if (reference != null && reference.get() != null) {
            throw new IllegalArgumentException("Instance already bound for class " + clazz.getName());
        }
        if (!clazz.isInstance(instance)) {
            throw new IllegalArgumentException("Instance of " + instance.getClass().getName() + " is not assignable to " + clazz.getName());
        }
        if (this.loader != clazz.getClassLoader() && this.loader != ClassLoader.getSystemClassLoader()) {
            throw new SecurityException("Illegal binder access from class loader '" + this.loader.getName() + "'");
        }
        this.bindings.put(clazz, new WeakReference<T>(instance));
    }

    @Override
    public <T> Optional<T> get(Class<T> clazz) throws SecurityException {
        if (this.loader != clazz.getClassLoader() && this.loader != ClassLoader.getSystemClassLoader()) {
            throw new SecurityException("Illegal binder access from class loader '" + this.loader.getName() + "'");
        }
        WeakReference<Object> reference = this.bindings.get(clazz);
        if (reference == null) {
            return Optional.empty();
        }
        Object instance = reference.get();
        if (instance != null) {
            return Optional.of(clazz.cast(instance));
        }
        this.bindings.remove(clazz);
        return Optional.empty();
    }

    @Override
    public <T> T find(Class<T> clazz) throws IllegalStateException, SecurityException {
        return this.get(clazz).orElseThrow(() -> new IllegalStateException("No instance found for " + clazz.getName()));
    }
}

