/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands.notification;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.notification.Notification;
import net.thenextlvl.portals.notification.NotificationTrigger;
import net.thenextlvl.portals.notification.Notifications;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.commands.PortalCommand;
import net.thenextlvl.portals.plugin.commands.arguments.NotificationTriggerArgumentType;
import net.thenextlvl.portals.plugin.commands.brigadier.SimpleCommand;
import net.thenextlvl.portals.plugin.commands.suggestions.PortalNotificationTriggerSuggestionProvider;
import net.thenextlvl.portals.plugin.commands.suggestions.PortalWithNotificationSuggestionProvider;
import net.thenextlvl.portals.view.UnparsedTitle;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class NotificationListCommand
extends SimpleCommand {
    private NotificationListCommand(PortalsPlugin plugin) {
        super(plugin, "list", "portals.command.notification.list");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        NotificationListCommand command = new NotificationListCommand(plugin);
        RequiredArgumentBuilder trigger = Commands.argument((String)"trigger", (ArgumentType)new NotificationTriggerArgumentType()).suggests((SuggestionProvider)new PortalNotificationTriggerSuggestionProvider());
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)PortalCommand.portalArgument(plugin).suggests(new PortalWithNotificationSuggestionProvider()).then(trigger.executes((Command)command))).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Portal portal = (Portal)context.getArgument("portal", Portal.class);
        NotificationTrigger trigger = this.tryGetArgument(context, "trigger", NotificationTrigger.class).orElse(null);
        if (trigger != null) {
            this.list(portal, trigger, sender);
            return 1;
        }
        Notifications notifications = portal.getNotifications();
        if (notifications.isEmpty()) {
            this.plugin.bundle().sendMessage((Audience)sender, "portal.notification.list.empty", new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName())});
            return 0;
        }
        notifications.stream().map(Notification::trigger).distinct().forEach(notification -> this.list(portal, (NotificationTrigger)notification, sender));
        return 1;
    }

    private void list(Portal portal, NotificationTrigger trigger, CommandSender sender) {
        List<Component> notifications = portal.getNotifications().findByTrigger(trigger).map(notification -> this.plugin.bundle().component("portal.notification.list.entry", (Audience)sender, new TagResolver[]{Placeholder.parsed((String)"type", (String)notification.type().getName()), Placeholder.parsed((String)"command", (String)this.toEditCommand(portal, (Notification<?>)notification))})).toList();
        String message = notifications.isEmpty() ? "portal.notification.list.empty.trigger" : "portal.notification.list.trigger";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName()), Placeholder.parsed((String)"trigger", (String)trigger.getName()), Formatter.number((String)"count", (Number)notifications.size()), Formatter.joining((String)"notifications", notifications)});
    }

    private String toEditCommand(Portal portal, Notification<?> notification) {
        return "/portal notification set " + portal.getName() + " " + notification.trigger().getName() + " " + notification.type().getName() + " " + NotificationListCommand.toString(notification);
    }

    private static String toString(Notification<?> notification) {
        Object obj = notification.input();
        Objects.requireNonNull(obj);
        Object obj2 = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnparsedTitle.class, Sound.class}, obj2, n)) {
            case 0 -> {
                UnparsedTitle unparsed = (UnparsedTitle)obj2;
                yield NotificationListCommand.toString(unparsed);
            }
            case 1 -> {
                Sound sound = (Sound)obj2;
                yield NotificationListCommand.toString(sound);
            }
            default -> String.valueOf(notification.input());
        };
    }

    private static String toString(UnparsedTitle unparsed) {
        String string = StringArgumentType.escapeIfRequired((String)unparsed.title()) + " " + StringArgumentType.escapeIfRequired((String)unparsed.subtitle());
        if (unparsed.times() == null) {
            return string;
        }
        String times = (double)unparsed.times().fadeIn().toMillis() / 1000.0 + "s " + (double)unparsed.times().stay().toMillis() / 1000.0 + "s " + (double)unparsed.times().fadeOut().toMillis() / 1000.0 + "s";
        return string + " " + times;
    }

    private static String toString(Sound sound) {
        return sound.name().asString() + " " + sound.source().name() + " " + sound.volume() + " " + sound.pitch();
    }
}

