/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class EnumArgumentType<E extends Enum<E>>
implements CustomArgumentType.Converted<E, String> {
    private final Class<E> enumClass;

    public EnumArgumentType(Class<E> enumClass) {
        this.enumClass = enumClass;
    }

    public E convert(String nativeType) {
        String normalized = nativeType.toUpperCase(Locale.ROOT).replaceAll("-", "_");
        return Enum.valueOf(this.enumClass, normalized);
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(String::toLowerCase).map(string -> string.replace("_", "-")).map(StringArgumentType::escapeIfRequired).filter(s -> s.contains(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

