/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.utils;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Deque;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.StringTag;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import org.intellij.lang.annotations.PrintFormat;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class Debugger {
    private final int maxLogs = Integer.getInteger("portals.debug.max-logs", 250);
    private final long startTime = System.currentTimeMillis();
    private final Deque<String> logs = new LinkedBlockingDeque<String>(this.maxLogs);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final AtomicBoolean broadcast = new AtomicBoolean();
    private final AtomicInteger omittedLogs = new AtomicInteger();
    private final AtomicInteger transaction = new AtomicInteger();
    private final NBT nbt = NBT.builder().setPrettyPrinting(true).setIndents(2).build();
    private final PortalsPlugin plugin;

    public Debugger(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean getBroadcast() {
        return this.broadcast.get();
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast.set(broadcast);
    }

    public Transaction newTransaction() {
        return new Transaction(this.transaction.incrementAndGet());
    }

    public String buildPaste() {
        CompoundTag.Builder debug = CompoundTag.builder();
        ListTag.Builder portals = ListTag.builder().contentType((byte)10);
        ListTag.Builder<StringTag> logs = ListTag.builder().contentType((byte)8);
        ListTag.Builder errors = ListTag.builder().contentType((byte)8);
        debug.put("version", this.plugin.getPluginMeta().getVersion());
        debug.put("server", this.plugin.getServer().getName() + " " + this.plugin.getServer().getVersion());
        debug.put("uptime", Debugger.durationToString(Duration.ofMillis(System.currentTimeMillis() - this.startTime)));
        int omitted = this.omittedLogs.get();
        if (omitted > 0) {
            logs.add(StringTag.of("Omitted " + omitted + " logs"));
        }
        this.plugin.portalProvider().portals.stream().map(portal -> {
            try {
                NBT nbt = this.plugin.nbt(portal.getWorld());
                return CompoundTag.builder().put("world", nbt.serialize(portal.getWorld().getKey())).putAll(nbt.serialize(portal).getAsCompound()).build();
            }
            catch (Exception e) {
                this.plugin.getComponentLogger().warn("Failed to serialize portal {}", (Object)portal.getName(), (Object)e);
                this.plugin.getComponentLogger().warn("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/portals/issues/new?template=bug_report.yml");
                errors.add(StringTag.of("Failed to serialize portal " + portal.getName() + ": " + e.getMessage()));
                PortalsPlugin.ERROR_TRACKER.trackError(e);
                return null;
            }
        }).filter(Objects::nonNull).forEach(portals::add);
        this.logs.stream().map(StringTag::of).forEach(logs::add);
        debug.put("config", CompoundTag.builder().put("allowCaveSpawns", this.plugin.config().allowCaveSpawns()).put("entryCosts", this.plugin.config().entryCosts()).put("ignoreEntityMovement", this.plugin.config().ignoreEntityMovement()).put("pushbackSpeed", this.plugin.config().pushbackSpeed()).build());
        if (!portals.isEmpty()) {
            debug.put("portals", portals.build());
        }
        if (!logs.isEmpty()) {
            debug.put("logs", logs.build());
        }
        if (!errors.isEmpty()) {
            debug.put("errors", errors.build());
        }
        return this.nbt.toString(debug.build());
    }

    public CompletableFuture<String> uploadPaste(String content) {
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.pastes.dev/post")).header("Content-Type", "text/plain").POST(HttpRequest.BodyPublishers.ofString(content)).timeout(Duration.ofSeconds(5L)).build();
            CompletableFuture<String> completableFuture = ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 201) {
                    String trim = ((String)response.body()).trim();
                    return "https://pastes.dev/" + trim.substring(8, trim.length() - 2);
                }
                throw new RuntimeException("Failed to upload paste (" + response.statusCode() + "): " + (String)response.body());
            })).orTimeout(5L, TimeUnit.SECONDS);
            return completableFuture;
        }
    }

    public static String durationToString(Duration duration) {
        long millis = duration.toMillis();
        if (millis < 1000L) {
            return millis + " milliseconds";
        }
        long seconds = duration.toSeconds();
        if (Math.abs(seconds) < 60L) {
            return seconds + " seconds";
        }
        long minutes = duration.toMinutes();
        if (Math.abs(minutes) < 60L) {
            return minutes + " minutes";
        }
        long hours = duration.toHours();
        if (Math.abs(hours) < 24L) {
            return hours + " hours";
        }
        return duration.toDays() + " days";
    }

    public final class Transaction {
        private final int id;

        public Transaction(int id) {
            this.id = id;
        }

        public void log(@PrintFormat String log, Object ... args) {
            String message = String.format(log, args);
            String time = Debugger.this.formatter.format(Instant.now().atZone(ZoneId.systemDefault()));
            String entry = "[" + time + "] #" + this.id + " " + message;
            if (Debugger.this.getBroadcast()) {
                this.broadcast(message);
            }
            while (!Debugger.this.logs.offer(entry)) {
                Debugger.this.logs.pollFirst();
                Debugger.this.omittedLogs.incrementAndGet();
            }
        }

        private void broadcast(String message) {
            Component prefix = Debugger.this.plugin.bundle().component("prefix", Locale.US);
            Component component = prefix.append((Component)Component.text((String)" (", (TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((String)("#" + this.id), (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)") ", (TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((String)message, (Style)Style.style((TextDecoration)TextDecoration.ITALIC)));
            Debugger.this.plugin.getServer().broadcast(component, "portals.debug");
        }
    }
}

