/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.adapters;

import io.papermc.paper.math.BlockPosition;
import net.kyori.adventure.key.Key;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.portals.PortalLike;
import net.thenextlvl.portals.action.ActionType;
import net.thenextlvl.portals.action.ActionTypeRegistry;
import net.thenextlvl.portals.action.EntryAction;
import net.thenextlvl.portals.bounds.Bounds;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.adapters.BlockPositionAdapter;
import net.thenextlvl.portals.plugin.adapters.BoundsAdapter;
import net.thenextlvl.portals.plugin.adapters.KeyAdapter;
import net.thenextlvl.portals.plugin.adapters.LazyLocationAdapter;
import net.thenextlvl.portals.plugin.adapters.PortalLikeAdapter;
import org.bukkit.Location;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EntryActionAdapter
implements TagAdapter<EntryAction<?>> {
    private final NBT nbt;

    public EntryActionAdapter(PortalsPlugin plugin) {
        this.nbt = NBT.builder().registerTypeHierarchyAdapter((Class<?>)BlockPosition.class, new BlockPositionAdapter()).registerTypeHierarchyAdapter((Class<?>)Bounds.class, new BoundsAdapter()).registerTypeHierarchyAdapter((Class<?>)Key.class, new KeyAdapter()).registerTypeHierarchyAdapter((Class<?>)Location.class, new LazyLocationAdapter()).registerTypeHierarchyAdapter((Class<?>)PortalLike.class, new PortalLikeAdapter(plugin)).build();
    }

    @Override
    public EntryAction<?> deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        String typeName = root.get("type").getAsString();
        ActionType actionType = ActionTypeRegistry.registry().getByName(typeName).orElseThrow(() -> new ParserException("Unknown action type: " + typeName));
        Object input = this.nbt.deserialize((Tag)root.get("input"), actionType.getType());
        return EntryAction.create(actionType, input);
    }

    @Override
    public Tag serialize(EntryAction<?> action, TagSerializationContext context) throws ParserException {
        return CompoundTag.builder().put("type", action.getActionType().getName()).put("input", this.nbt.serialize(action.getInput(), action.getActionType().getType())).build();
    }
}

