/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.listeners;

import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.math.Position;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import io.papermc.paper.util.Tick;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.event.EntityPortalExitEvent;
import net.thenextlvl.portals.event.EntityPortalWarmupCancelEvent;
import net.thenextlvl.portals.event.EntityPortalWarmupEvent;
import net.thenextlvl.portals.event.PreEntityPortalEnterEvent;
import net.thenextlvl.portals.notification.NotificationTrigger;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.portal.PaperPortal;
import net.thenextlvl.portals.plugin.utils.Debugger;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PortalListener
implements Listener {
    private static final Map<UUID, Portal> lastPortal = new HashMap<UUID, Portal>();
    private final PortalsPlugin plugin;

    public PortalListener(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityMove(EntityMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        if (this.plugin.config().ignoreEntityMovement()) {
            return;
        }
        if (this.processMovement((Entity)event.getEntity(), event.getTo())) {
            return;
        }
        this.pushAway((Entity)event.getEntity(), event.getTo());
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        if (this.processMovement((Entity)event.getPlayer(), event.getTo())) {
            return;
        }
        this.pushAway((Entity)event.getPlayer(), event.getTo());
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (event.isSneaking()) {
            return;
        }
        if (this.processMovement((Entity)event.getPlayer(), event.getPlayer().getLocation())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityPortalEnter(EntityPortalEnterEvent event) {
        this.plugin.portalProvider().getPortals(event.getLocation().getWorld()).filter(portal -> portal.getBoundingBox().contains((Position)event.getLocation())).findAny().ifPresent(portal -> event.setCancelled(true));
    }

    private boolean processMovement(Entity entity, Location to) {
        BoundingBox boundingBox = PortalListener.translate(entity.getBoundingBox(), to);
        return this.plugin.portalProvider().getPortals(entity.getWorld()).filter(portal -> portal.getBoundingBox().overlaps(boundingBox)).findAny().map(portal -> (PaperPortal)portal).map(portal -> {
            if (portal.equals(lastPortal.get(entity.getUniqueId()))) {
                return true;
            }
            Debugger.Transaction transaction = this.plugin.debugger.newTransaction();
            transaction.log("'%s' entered the portal '%s'", entity.getName(), portal.getName());
            if (!new PreEntityPortalEnterEvent((Portal)portal, entity).callEvent()) {
                portal.getNotifications().trigger(NotificationTrigger.entryFailure(), entity);
                transaction.log("PreEntityPortalEnterEvent was cancelled for '%s' in '%s'", entity.getName(), portal.getName());
                return false;
            }
            if (!portal.getEntryPermission().map(arg_0 -> ((Entity)entity).hasPermission(arg_0)).orElse(true).booleanValue()) {
                portal.getNotifications().trigger(NotificationTrigger.entryFailure(), entity);
                transaction.log("EntryPermission was not met for '%s' in '%s' (%s)", entity.getName(), portal.getName(), portal.getEntryPermission().orElse(null));
                return false;
            }
            if (portal.getCooldown().isPositive() && portal.getRemainingCooldown(entity).isPositive()) {
                portal.getNotifications().trigger(NotificationTrigger.entryFailure(), entity);
                transaction.log("Cooldown was not met for '%s' in '%s' (%s left)", entity.getName(), portal.getName(), Debugger.durationToString(portal.getRemainingCooldown(entity)));
                return false;
            }
            if (portal.getEntryCost() > 0.0 && !this.withdrawEntryCost((Portal)portal, entity)) {
                portal.getNotifications().trigger(NotificationTrigger.entryFailure(), entity);
                transaction.log("EntryCost was not met for '%s' in '%s' (%s)", entity.getName(), portal.getName(), portal.getEntryCost());
                return false;
            }
            if (!new net.thenextlvl.portals.event.EntityPortalEnterEvent((Portal)portal, entity).callEvent()) {
                portal.getNotifications().trigger(NotificationTrigger.entryFailure(), entity);
                transaction.log("EntityPortalEnterEvent was cancelled for '%s' in '%s'", entity.getName(), portal.getName());
                return false;
            }
            if (portal.getCooldown().isPositive()) {
                portal.startCooldown(entity);
            }
            PortalListener.setLastPortal(entity, portal);
            this.resetWarmupIfPresent(entity);
            boolean warmingUp = this.startWarmup(entity, (PaperPortal)portal, transaction);
            portal.getNotifications().trigger(NotificationTrigger.entrySuccess(), entity);
            if (warmingUp) {
                return true;
            }
            return portal.getEntryAction().map(action -> {
                if (action.onEntry(entity, (Portal)portal)) {
                    transaction.log("EntryAction was successful for '%s' in '%s'", entity.getName(), portal.getName());
                    portal.getNotifications().trigger(NotificationTrigger.teleportSuccess(), entity);
                    return true;
                }
                transaction.log("EntryAction was cancelled for '%s' in '%s'", entity.getName(), portal.getName());
                portal.getNotifications().trigger(NotificationTrigger.teleportFailure(), entity);
                return false;
            }).orElseGet(() -> {
                transaction.log("No EntryAction for '%s' in '%s'", entity.getName(), portal.getName());
                return true;
            });
        }).orElseGet(() -> {
            this.resetWarmupIfPresent(entity);
            Portal portal = lastPortal.remove(entity.getUniqueId());
            if (portal != null) {
                portal.getNotifications().trigger(NotificationTrigger.exit(), entity);
                new EntityPortalExitEvent(portal, entity).callEvent();
            }
            return true;
        });
    }

    private boolean startWarmup(Entity entity, PaperPortal portal, Debugger.Transaction transaction) {
        if (!portal.getWarmup().isPositive()) {
            return false;
        }
        ScheduledTask scheduledTask = this.scheduleWarmupCheck(entity, portal, portal.getWarmup(), transaction);
        if (scheduledTask == null) {
            return false;
        }
        Instant finished = Instant.now().plus(portal.getWarmup());
        PaperPortal.WARMUPS.put(entity.getUniqueId(), new PaperPortal.Warmup(portal, finished, scheduledTask, transaction));
        new EntityPortalWarmupEvent(portal, entity).callEvent();
        return true;
    }

    private @Nullable ScheduledTask scheduleWarmupCheck(Entity entity, PaperPortal portal, Duration delay, Debugger.Transaction transaction) {
        transaction.log("Starting warmup for '%s' in '%s' (%s left)", entity.getName(), portal.getName(), Debugger.durationToString(delay));
        return entity.getScheduler().runDelayed((Plugin)this.plugin, task -> {
            portal.getNotifications().trigger(NotificationTrigger.warmupSuccess(), entity);
            PaperPortal.WARMUPS.remove(entity.getUniqueId());
            portal.getEntryAction().ifPresentOrElse(action -> {
                if (action.onEntry(entity, portal)) {
                    transaction.log("EntryAction was successful for '%s' in '%s' (after warmup)", entity.getName(), portal.getName());
                    portal.getNotifications().trigger(NotificationTrigger.teleportSuccess(), entity);
                } else {
                    transaction.log("EntryAction was cancelled for '%s' in '%s' (after warmup)", entity.getName(), portal.getName());
                    portal.getNotifications().trigger(NotificationTrigger.teleportFailure(), entity);
                }
            }, () -> transaction.log("No EntryAction for '%s' in '%s' (after warmup)", entity.getName(), portal.getName()));
        }, () -> {
            transaction.log("Cancelled warmup for '%s' in '%s' (retired)", entity.getName(), portal.getName());
            PaperPortal.WARMUPS.remove(entity.getUniqueId());
        }, (long)Math.max(1, Tick.tick().fromDuration(delay)));
    }

    private void resetWarmupIfPresent(Entity entity) {
        PaperPortal.Warmup warmup = PaperPortal.WARMUPS.get(entity.getUniqueId());
        if (warmup == null) {
            return;
        }
        warmup.task().cancel();
        Duration remaining = Duration.between(Instant.now(), warmup.finished());
        new EntityPortalWarmupCancelEvent(warmup.portal(), entity, remaining).callEvent();
        warmup.transaction().log("Cancelled warmup for '%s' in '%s' (%s left)", entity.getName(), warmup.portal().getName(), Debugger.durationToString(remaining));
        warmup.portal().getNotifications().trigger(NotificationTrigger.warmupFailure(), entity);
        PaperPortal.WARMUPS.remove(entity.getUniqueId());
    }

    private void pushAway(Entity entity, Location to) {
        double speed = this.plugin.config().pushbackSpeed();
        if (speed > 0.0) {
            entity.getScheduler().run((Plugin)this.plugin, task -> {
                Vector direction = entity.getLocation().toVector().subtract(to.toVector()).normalize();
                entity.setVelocity(direction.multiply(speed));
            }, null);
        }
    }

    private boolean withdrawEntryCost(Portal portal, Entity entity) {
        if (!this.plugin.config().entryCosts()) {
            return true;
        }
        if (!(entity instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        return this.plugin.economyProvider().withdraw(player, portal.getEntryCost());
    }

    public static void setLastPortal(Entity entity, Portal portal) {
        lastPortal.put(entity.getUniqueId(), portal);
    }

    private static BoundingBox translate(BoundingBox boundingBox, Location location) {
        double widthX = boundingBox.getWidthX() / 2.0;
        double widthZ = boundingBox.getWidthZ() / 2.0;
        return new BoundingBox(location.getX() - widthX, location.getY(), location.getZ() - widthZ, location.getX() + widthX, location.getY() + boundingBox.getHeight(), location.getZ() + widthZ);
    }
}

