/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.economy;

import java.util.Locale;
import java.util.Optional;
import net.milkbowl.vault.economy.Economy;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.economy.EconomyProvider;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class VaultEconomyProvider
implements EconomyProvider {
    private final PortalsPlugin plugin;

    public VaultEconomyProvider(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    private Optional<Economy> getEconomy() {
        return Optional.ofNullable((Economy)this.plugin.getServer().getServicesManager().load(Economy.class));
    }

    @Override
    public String format(Locale locale, double amount) {
        return this.getEconomy().map(economy -> economy.format(amount)).orElseGet(() -> EconomyProvider.super.format(locale, amount));
    }

    @Override
    public boolean withdraw(Player player, double amount) {
        return this.getEconomy().map(economy -> economy.withdrawPlayer((OfflinePlayer)player, amount).transactionSuccess()).orElse(false);
    }
}

