/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands.notification.argument;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.time.Duration;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.Ticks;
import net.thenextlvl.portals.notification.NotificationType;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.commands.notification.argument.PortalNotificationCommand;
import net.thenextlvl.portals.view.UnparsedTitle;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SendTitleCommand
extends PortalNotificationCommand<UnparsedTitle> {
    private SendTitleCommand(PortalsPlugin plugin) {
        super(plugin, NotificationType.title());
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        SendTitleCommand command = new SendTitleCommand(plugin);
        RequiredArgumentBuilder title = (RequiredArgumentBuilder)Commands.argument((String)"title", (ArgumentType)StringArgumentType.string()).executes((Command)command);
        RequiredArgumentBuilder subtitle = (RequiredArgumentBuilder)Commands.argument((String)"subtitle", (ArgumentType)StringArgumentType.string()).executes((Command)command);
        ArgumentBuilder<CommandSourceStack, ?> times = command.titleTimesArgument();
        return (LiteralArgumentBuilder)command.create().then(title.then(subtitle.then(times)));
    }

    private ArgumentBuilder<CommandSourceStack, ?> titleTimesArgument() {
        RequiredArgumentBuilder fadeIn = Commands.argument((String)"fade-in", (ArgumentType)ArgumentTypes.time());
        RequiredArgumentBuilder stay = Commands.argument((String)"stay", (ArgumentType)ArgumentTypes.time());
        RequiredArgumentBuilder fadeOut = Commands.argument((String)"fade-out", (ArgumentType)ArgumentTypes.time());
        return fadeIn.then(stay.then(fadeOut.executes((Command)this)));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        String title = (String)context.getArgument("title", String.class);
        String subtitle = this.tryGetArgument(context, "subtitle", String.class).orElse("");
        Duration fadeIn = this.tryGetArgument(context, "fade-in", Integer.TYPE).map(Ticks::duration).orElse(null);
        Duration stay = this.tryGetArgument(context, "stay", Integer.TYPE).map(Ticks::duration).orElse(null);
        Duration fadeOut = this.tryGetArgument(context, "fade-out", Integer.TYPE).map(Ticks::duration).orElse(null);
        Title.Times times = fadeIn != null && stay != null && fadeOut != null ? Title.Times.times((Duration)fadeIn, (Duration)stay, (Duration)fadeOut) : null;
        return this.addAction(context, new UnparsedTitle(title, subtitle, times));
    }
}

