/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands.notification.argument;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.notification.NotificationTrigger;
import net.thenextlvl.portals.notification.NotificationType;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.commands.brigadier.SimpleCommand;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
abstract class PortalNotificationCommand<T>
extends SimpleCommand {
    private final NotificationType<T> notificationType;

    protected PortalNotificationCommand(PortalsPlugin plugin, NotificationType<T> notificationType) {
        super(plugin, notificationType.getName(), null);
        this.notificationType = notificationType;
    }

    protected int addAction(CommandContext<CommandSourceStack> context, T input) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Portal portal = (Portal)context.getArgument("portal", Portal.class);
        NotificationTrigger trigger = (NotificationTrigger)context.getArgument("trigger", NotificationTrigger.class);
        boolean success = portal.getNotifications().set(trigger, this.notificationType, input);
        String message = success ? "portal.notification.added" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"type", (String)this.notificationType.getName()), Placeholder.unparsed((String)"trigger", (String)trigger.getName()), Placeholder.unparsed((String)"portal", (String)portal.getName())});
        return success ? 1 : 0;
    }
}

