/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands.notification;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.notification.Notification;
import net.thenextlvl.portals.notification.NotificationTrigger;
import net.thenextlvl.portals.notification.NotificationType;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.commands.PortalCommand;
import net.thenextlvl.portals.plugin.commands.arguments.NotificationTriggerArgumentType;
import net.thenextlvl.portals.plugin.commands.brigadier.SimpleCommand;
import net.thenextlvl.portals.plugin.commands.suggestions.PortalNotificationSuggestionProvider;
import net.thenextlvl.portals.plugin.commands.suggestions.PortalNotificationTriggerSuggestionProvider;
import net.thenextlvl.portals.plugin.commands.suggestions.PortalWithNotificationSuggestionProvider;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class NotificationRemoveCommand
extends SimpleCommand {
    private NotificationRemoveCommand(PortalsPlugin plugin) {
        super(plugin, "remove", "portals.command.notification.remove");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        NotificationRemoveCommand command = new NotificationRemoveCommand(plugin);
        RequiredArgumentBuilder trigger = Commands.argument((String)"trigger", (ArgumentType)new NotificationTriggerArgumentType()).suggests((SuggestionProvider)new PortalNotificationTriggerSuggestionProvider());
        RequiredArgumentBuilder notification = Commands.argument((String)"notification", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PortalNotificationSuggestionProvider());
        return (LiteralArgumentBuilder)command.create().then(PortalCommand.portalArgument(plugin).suggests(new PortalWithNotificationSuggestionProvider()).then(trigger.then(notification.executes((Command)command))));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Portal portal = (Portal)context.getArgument("portal", Portal.class);
        NotificationTrigger trigger = (NotificationTrigger)context.getArgument("trigger", NotificationTrigger.class);
        String notification = (String)context.getArgument("notification", String.class);
        Boolean success = portal.getNotifications().findByTrigger(trigger).map(Notification::type).filter(type -> type.getName().equals(notification)).findAny().map(n -> portal.getNotifications().remove(trigger, (NotificationType<?>)n)).orElse(false);
        String message = success != false ? "portal.notification.removed" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName()), Placeholder.parsed((String)"trigger", (String)trigger.getName()), Placeholder.parsed((String)"type", (String)notification)});
        return success != false ? 1 : 0;
    }
}

