/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.notification;

import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.KeyPattern;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.notification.NotificationType;
import net.thenextlvl.portals.view.UnparsedTitle;
import org.bukkit.entity.Entity;

record SimpleNotificationType<T>(@KeyPattern.Value String name, Class<T> type, NotificationType.Sender<T> sender) implements NotificationType<T>
{
    public static final NotificationType<Sound> PLAY_SOUND = NotificationType.create("sound", Sound.class, (entity, portal, input) -> entity.playSound(input));
    public static final NotificationType<String> MESSAGE = NotificationType.create("message", String.class, (entity, portal, input) -> entity.sendMessage(MiniMessage.miniMessage().deserialize(input, SimpleNotificationType.placeholders(entity, portal))));
    public static final NotificationType<UnparsedTitle> TITLE = NotificationType.create("title", UnparsedTitle.class, (entity, portal, input) -> {
        MiniMessage miniMessage = MiniMessage.miniMessage();
        TagResolver[] placeholders = SimpleNotificationType.placeholders(entity, portal);
        Component title = miniMessage.deserialize(input.title(), placeholders);
        Component subtitle = miniMessage.deserialize(input.subtitle(), placeholders);
        entity.showTitle(Title.title((Component)title, (Component)subtitle, (Title.Times)input.times()));
    });
    public static final NotificationType<String> ACTIONBAR = NotificationType.create("actionbar", String.class, (entity, portal, input) -> entity.sendActionBar(MiniMessage.miniMessage().deserialize(input, SimpleNotificationType.placeholders(entity, portal))));

    private static TagResolver[] placeholders(Entity entity, Portal portal) {
        return new TagResolver[]{Formatter.number((String)"cooldown", (Number)((double)portal.getCooldown().toMillis() / 1000.0)), Formatter.number((String)"remaining-cooldown", (Number)((double)portal.getRemainingCooldown(entity).toMillis() / 1000.0)), Formatter.number((String)"remaining-warmup", (Number)((double)portal.getRemainingWarmup(entity).toMillis() / 1000.0)), Formatter.number((String)"warmup", (Number)((double)portal.getWarmup().toMillis() / 1000.0)), Placeholder.parsed((String)"entity", (String)entity.getName()), Placeholder.parsed((String)"entry-cost", (String)portal.getFormattedEntryCost((Audience)entity)), Placeholder.parsed((String)"permission", (String)portal.getEntryPermission().orElse("undefined")), Placeholder.parsed((String)"portal", (String)portal.getName())};
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    @KeyPattern.Value
    public String getName() {
        return this.name;
    }

    @Override
    public NotificationType.Sender<T> getSender() {
        return this.sender;
    }
}

