/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.commands.PortalCommand;
import net.thenextlvl.portals.plugin.commands.arguments.DurationArgumentType;
import net.thenextlvl.portals.plugin.commands.brigadier.SimpleCommand;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class PortalWarmupCommand
extends SimpleCommand {
    public PortalWarmupCommand(PortalsPlugin plugin) {
        super(plugin, "warmup", "portals.command.warmup");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        PortalWarmupCommand command = new PortalWarmupCommand(plugin);
        RequiredArgumentBuilder warmup = Commands.argument((String)"warmup", (ArgumentType)DurationArgumentType.duration());
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)PortalCommand.portalArgument(plugin).then(warmup.executes((Command)command))).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Portal portal = (Portal)context.getArgument("portal", Portal.class);
        Duration warmup = this.tryGetArgument(context, "warmup", Duration.class).orElse(null);
        if (warmup == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "portal.warmup.current", new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName()), Formatter.number((String)"warmup", (Number)((double)portal.getWarmup().toMillis() / 1000.0))});
            return 1;
        }
        boolean success = portal.setWarmup(warmup);
        String message = success ? "portal.warmup.set" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName()), Formatter.number((String)"warmup", (Number)((double)warmup.toMillis() / 1000.0))});
        return success ? 1 : 0;
    }
}

