/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.utils;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.StringTag;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import org.intellij.lang.annotations.PrintFormat;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class Debugger {
    private final int maxLogs = Integer.getInteger("portals.debug.max-logs", 250);
    private final long startTime = System.currentTimeMillis();
    private final ArrayDeque<String> logs = new ArrayDeque(this.maxLogs);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private int transaction = 1;
    public int omittedLogs = 0;
    private final NBT nbt = NBT.builder().setPrettyPrinting(true).setIndents(2).build();
    private final PortalsPlugin plugin;

    public Debugger(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    public void newTransaction() {
        ++this.transaction;
    }

    public void log(@PrintFormat String log, Object ... args) {
        if (this.logs.size() >= this.maxLogs) {
            this.logs.removeFirst();
            ++this.omittedLogs;
        }
        String time = this.formatter.format(Instant.now().atZone(ZoneId.systemDefault()));
        this.logs.add("[" + time + "] #" + this.transaction + " " + String.format(log, args));
    }

    public Stream<String> logs() {
        return this.logs.stream();
    }

    public String durationToString(Duration duration) {
        long millis = duration.toMillis();
        if (millis < 1000L) {
            return millis + " milliseconds";
        }
        long seconds = duration.toSeconds();
        if (Math.abs(seconds) < 60L) {
            return seconds + " seconds";
        }
        long minutes = duration.toMinutes();
        if (Math.abs(minutes) < 60L) {
            return minutes + " minutes";
        }
        long hours = duration.toHours();
        if (Math.abs(hours) < 24L) {
            return hours + " hours";
        }
        return duration.toDays() + " days";
    }

    public String buildPaste() {
        CompoundTag.Builder debug = CompoundTag.builder();
        ListTag.Builder portals = ListTag.builder().contentType((byte)10);
        ListTag.Builder<StringTag> logs = ListTag.builder().contentType((byte)8);
        ListTag.Builder errors = ListTag.builder().contentType((byte)8);
        debug.put("version", this.plugin.getPluginMeta().getVersion());
        debug.put("server", this.plugin.getServer().getName() + " " + this.plugin.getServer().getVersion());
        debug.put("uptime", this.durationToString(Duration.ofMillis(System.currentTimeMillis() - this.startTime)));
        if (this.omittedLogs > 0) {
            logs.add(StringTag.of("Omitted " + this.omittedLogs + " logs"));
        }
        this.plugin.portalProvider().portals.stream().map(portal -> {
            try {
                NBT nbt = this.plugin.nbt(portal.getWorld());
                return CompoundTag.builder().put("world", nbt.serialize(portal.getWorld().getKey())).putAll(nbt.serialize(portal).getAsCompound()).build();
            }
            catch (Exception e) {
                this.plugin.getComponentLogger().warn("Failed to serialize portal {}", (Object)portal.getName(), (Object)e);
                this.plugin.getComponentLogger().warn("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/portals/issues/new?template=bug_report.yml");
                errors.add(StringTag.of("Failed to serialize portal " + portal.getName() + ": " + e.getMessage()));
                PortalsPlugin.ERROR_TRACKER.trackError(e);
                return null;
            }
        }).filter(Objects::nonNull).forEach(portals::add);
        this.logs().map(StringTag::of).forEach(logs::add);
        debug.put("config", CompoundTag.builder().put("allowCaveSpawns", this.plugin.config().allowCaveSpawns()).put("entryCosts", this.plugin.config().entryCosts()).put("ignoreEntityMovement", this.plugin.config().ignoreEntityMovement()).put("pushbackSpeed", this.plugin.config().pushbackSpeed()).build());
        if (!portals.isEmpty()) {
            debug.put("portals", portals.build());
        }
        if (!logs.isEmpty()) {
            debug.put("logs", logs.build());
        }
        if (!errors.isEmpty()) {
            debug.put("errors", errors.build());
        }
        return this.nbt.toString(debug.build());
    }

    public CompletableFuture<String> uploadPaste(String content) {
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.pastes.dev/post")).header("Content-Type", "text/plain").POST(HttpRequest.BodyPublishers.ofString(content)).timeout(Duration.ofSeconds(5L)).build();
            CompletableFuture<String> completableFuture = ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 201) {
                    String trim = ((String)response.body()).trim();
                    return "https://pastes.dev/" + trim.substring(8, trim.length() - 2);
                }
                throw new RuntimeException("Failed to upload paste (" + response.statusCode() + "): " + (String)response.body());
            })).orTimeout(5L, TimeUnit.SECONDS);
            return completableFuture;
        }
    }
}

