/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.portal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.action.EntryAction;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.shape.BoundingBox;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperPortal
implements Portal {
    private final PortalsPlugin plugin;
    private final String name;
    private BoundingBox boundingBox;
    private Duration cooldown = Duration.ZERO;
    private Duration warmup = Duration.ZERO;
    private @Nullable String entryPermission = null;
    private @Nullable EntryAction<?> entryAction = null;
    private double entryCost = 0.0;
    private boolean persistent = true;
    private Path dataFile;
    private Path backupFile;

    public PaperPortal(PortalsPlugin plugin, String name, BoundingBox boundingBox) {
        this.plugin = plugin;
        this.name = name;
        this.boundingBox = boundingBox;
        Path dataFolder = plugin.portalProvider().getDataFolder(this.getWorld());
        this.dataFile = dataFolder.resolve(name + ".dat");
        this.backupFile = dataFolder.resolve(name + ".dat_old");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<Portal> getPortal() {
        return Optional.of(this);
    }

    @Override
    public World getWorld() {
        return this.boundingBox.getWorld();
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean setBoundingBox(BoundingBox boundingBox) {
        if (this.boundingBox.equals(boundingBox)) {
            return false;
        }
        if (boundingBox.getWorld().equals((Object)this.getWorld())) {
            this.boundingBox = boundingBox;
            return true;
        }
        Path target = this.plugin.portalProvider().getDataFolder(boundingBox.getWorld());
        Path dataFile = target.resolve(this.getDataFile().getFileName());
        Path backupFile = target.resolve(this.getBackupFile().getFileName());
        try {
            Files.createDirectories(target, new FileAttribute[0]);
            if (Files.exists(this.getDataFile(), new LinkOption[0])) {
                Files.move(this.getDataFile(), dataFile, StandardCopyOption.REPLACE_EXISTING);
            }
            if (Files.exists(this.getBackupFile(), new LinkOption[0])) {
                Files.move(this.getBackupFile(), backupFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().error("Failed to move portal data files for {}", (Object)this.getName(), (Object)e);
            this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/portals/issues/new?template=bug_report.yml");
            PortalsPlugin.ERROR_TRACKER.trackError(e);
            return false;
        }
        this.dataFile = dataFile;
        this.backupFile = backupFile;
        this.boundingBox = boundingBox;
        return true;
    }

    @Override
    public Optional<String> getEntryPermission() {
        return Optional.ofNullable(this.entryPermission);
    }

    @Override
    public boolean setEntryPermission(@Nullable String permission) {
        if (Objects.equals(this.entryPermission, permission)) {
            return false;
        }
        this.entryPermission = permission;
        return true;
    }

    @Override
    public Duration getCooldown() {
        return this.cooldown;
    }

    @Override
    public boolean setCooldown(Duration cooldown) throws IllegalArgumentException {
        Preconditions.checkArgument((!cooldown.isNegative() ? 1 : 0) != 0, (Object)"Cooldown cannot be negative");
        if (this.cooldown.equals(cooldown)) {
            return false;
        }
        this.cooldown = cooldown;
        return true;
    }

    @Override
    public Duration getWarmup() {
        return this.warmup;
    }

    @Override
    public boolean setWarmup(Duration warmup) throws IllegalArgumentException {
        Preconditions.checkArgument((!warmup.isNegative() ? 1 : 0) != 0, (Object)"Warmup cannot be negative");
        if (this.warmup.equals(warmup)) {
            return false;
        }
        this.warmup = warmup;
        return true;
    }

    @Override
    public double getEntryCost() {
        return this.entryCost;
    }

    @Override
    public boolean setEntryCost(double cost) throws IllegalArgumentException {
        Preconditions.checkArgument((cost >= 0.0 ? 1 : 0) != 0, (Object)"Entry cost cannot be negative");
        if (this.entryCost == cost) {
            return false;
        }
        this.entryCost = cost;
        return true;
    }

    @Override
    public Optional<EntryAction<?>> getEntryAction() {
        return Optional.ofNullable(this.entryAction);
    }

    @Override
    public boolean setEntryAction(@Nullable EntryAction<?> action) {
        if (Objects.equals(this.entryAction, action)) {
            return false;
        }
        this.entryAction = action;
        return true;
    }

    @Override
    public Path getDataFile() {
        return this.dataFile;
    }

    @Override
    public Path getBackupFile() {
        return this.backupFile;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public boolean setPersistent(boolean persistent) {
        if (this.persistent == persistent) {
            return false;
        }
        this.persistent = persistent;
        return true;
    }

    @Override
    public boolean persist() {
        boolean bl;
        block14: {
            if (!this.isPersistent()) {
                return false;
            }
            Path file = this.getDataFile();
            Path backup = this.getBackupFile();
            if (Files.isRegularFile(file, new LinkOption[0])) {
                Files.move(file, backup, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            NBTOutputStream outputStream = NBTOutputStream.create(file);
            try {
                outputStream.writeTag(this.getName(), this.plugin.nbt(this.getWorld()).serialize(this));
                bl = true;
                if (outputStream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    if (Files.isRegularFile(backup, new LinkOption[0])) {
                        try {
                            Files.copy(backup, file, StandardCopyOption.REPLACE_EXISTING);
                            this.plugin.getComponentLogger().warn("Recovered portal {} from potential data loss", (Object)this.getName());
                        }
                        catch (IOException e) {
                            this.plugin.getComponentLogger().error("Failed to restore portal {}", (Object)this.getName(), (Object)e);
                        }
                    }
                    this.plugin.getComponentLogger().error("Failed to save portal {}", (Object)this.getName(), (Object)t);
                    this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/portals/issues/new?template=bug_report.yml");
                    PortalsPlugin.ERROR_TRACKER.trackError(t);
                    return false;
                }
            }
            outputStream.close();
        }
        return bl;
    }

    public String toString() {
        return "PaperPortal{name='" + this.name + "', boundingBox=" + String.valueOf(this.boundingBox) + ", cooldown=" + String.valueOf(this.cooldown) + ", warmup=" + String.valueOf(this.warmup) + ", entryPermission='" + this.entryPermission + "', entryCost=" + this.entryCost + ", persistent=" + this.persistent + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaperPortal that = (PaperPortal)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

