/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.commands.PortalCommand;
import net.thenextlvl.portals.plugin.commands.brigadier.SimpleCommand;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class PortalTeleportCommand
extends SimpleCommand {
    public PortalTeleportCommand(PortalsPlugin plugin) {
        super(plugin, "teleport", "portals.command.teleport");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        PortalTeleportCommand command = new PortalTeleportCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(PortalCommand.portalArgument(plugin).executes((Command)command));
    }

    @Override
    protected boolean canUse(CommandSourceStack source) {
        return super.canUse(source) && source.getSender() instanceof Player;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Portal portal = (Portal)context.getArgument("portal", Portal.class);
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ((CompletableFuture)player.teleportAsync(portal.getBoundingBox().getCenter()).thenAccept(success -> {
            String message = success != false ? "portal.teleport.success" : "portal.teleport.failed";
            this.plugin.bundle().sendMessage((Audience)player, message, new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName())});
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().error("Failed to teleport player to portal", throwable);
            this.plugin.bundle().sendMessage((Audience)player, "portal.teleport.failed", new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName())});
            return null;
        });
        return 1;
    }
}

