/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.adapters;

import net.kyori.adventure.key.Key;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.portals.plugin.model.LazyLocation;
import org.bukkit.Location;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class LazyLocationAdapter
implements TagAdapter<Location> {
    @Override
    public Location deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        double x = root.get("x").getAsDouble();
        double y = root.get("y").getAsDouble();
        double z = root.get("z").getAsDouble();
        float yaw = root.get("yaw").getAsFloat();
        float pitch = root.get("pitch").getAsFloat();
        Key world = context.deserialize((Tag)root.get("world"), Key.class);
        return new LazyLocation(world, x, y, z, yaw, pitch);
    }

    @Override
    public Tag serialize(Location location, TagSerializationContext context) throws ParserException {
        Key key;
        if (location instanceof LazyLocation) {
            LazyLocation lazy = (LazyLocation)location;
            key = lazy.key();
        } else {
            key = location.getWorld().key();
        }
        Key world = key;
        return CompoundTag.builder().put("x", location.getX()).put("y", location.getY()).put("z", location.getZ()).put("yaw", Float.valueOf(location.getYaw())).put("pitch", Float.valueOf(location.getPitch())).put("world", context.serialize(world)).build();
    }
}

