/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.selections;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.session.SessionManager;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.Position;
import java.util.Optional;
import net.thenextlvl.portals.selection.SelectionProvider;
import net.thenextlvl.portals.shape.BoundingBox;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorldEditSelectionProvider
implements SelectionProvider {
    private final WorldEdit worldEdit = WorldEdit.getInstance();

    @Override
    public Optional<BoundingBox> getSelection(Player player) {
        BukkitPlayer owner;
        SessionManager manager = this.worldEdit.getSessionManager();
        LocalSession session = manager.getIfPresent((SessionOwner)(owner = BukkitAdapter.adapt((Player)player)));
        if (session == null) {
            return Optional.empty();
        }
        try {
            org.bukkit.World world;
            Region region = session.getSelection();
            if (!(region instanceof CuboidRegion)) {
                return Optional.empty();
            }
            CuboidRegion cuboid = (CuboidRegion)region;
            World world2 = cuboid.getWorld();
            if (world2 instanceof BukkitWorld) {
                BukkitWorld bukkit = (BukkitWorld)world2;
                world = bukkit.getWorld();
            } else {
                world = player.getWorld();
            }
            org.bukkit.World world3 = world;
            BlockPosition min = this.toPosition(cuboid.getMinimumPoint());
            BlockPosition max = this.toPosition(cuboid.getMaximumPoint()).offset(1, 1, 1);
            return Optional.of(BoundingBox.of(world3, (Position)min, (Position)max));
        }
        catch (IncompleteRegionException e) {
            return Optional.empty();
        }
    }

    @Override
    public boolean clearSelection(Player player) {
        BukkitPlayer owner;
        SessionManager manager = this.worldEdit.getSessionManager();
        if (!manager.contains((SessionOwner)(owner = BukkitAdapter.adapt((Player)player)))) {
            return false;
        }
        manager.remove((SessionOwner)owner);
        return true;
    }

    @Override
    public boolean hasSelection(Player player) {
        return this.getSelection(player).isPresent();
    }

    @Override
    public void setSelection(Player player, BoundingBox boundingBox) {
        SessionManager manager = this.worldEdit.getSessionManager();
        LocalSession session = manager.get((SessionOwner)BukkitAdapter.adapt((Player)player));
        CuboidRegionSelector selector = new CuboidRegionSelector(BukkitAdapter.adapt((org.bukkit.World)boundingBox.getWorld()), this.toBlockVector(boundingBox.getMinPosition()), this.toBlockVector(boundingBox.getMaxPosition()));
        session.setRegionSelector(BukkitAdapter.adapt((org.bukkit.World)boundingBox.getWorld()), (RegionSelector)selector);
    }

    private BlockPosition toPosition(BlockVector3 vector) {
        return Position.block((int)vector.x(), (int)vector.y(), (int)vector.z());
    }

    private BlockVector3 toBlockVector(Position position) {
        return BlockVector3.at((int)position.blockX(), (int)position.blockY(), (int)position.blockZ());
    }
}

