/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.action.EntryAction;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.adapters.debug.DurationAdapter;
import net.thenextlvl.portals.plugin.adapters.debug.EntryActionAdapter;
import net.thenextlvl.portals.plugin.adapters.debug.InetSocketAddressAdapter;
import net.thenextlvl.portals.plugin.adapters.debug.LazyPortalAdapter;
import net.thenextlvl.portals.plugin.adapters.debug.PathAdapter;
import net.thenextlvl.portals.plugin.adapters.debug.WorldAdapter;
import net.thenextlvl.portals.plugin.commands.brigadier.SimpleCommand;
import net.thenextlvl.portals.plugin.model.LazyPortal;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class PortalDebugPasteCommand
extends SimpleCommand {
    private final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, (Object)new PathAdapter()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).registerTypeAdapter(EntryAction.class, (Object)new EntryActionAdapter()).registerTypeHierarchyAdapter(World.class, (Object)new WorldAdapter()).registerTypeAdapter(LazyPortal.class, (Object)new LazyPortalAdapter()).registerTypeHierarchyAdapter(InetSocketAddress.class, (Object)new InetSocketAddressAdapter()).addSerializationExclusionStrategy((ExclusionStrategy)new DebugExclusionStrategy()).disableHtmlEscaping().disableJdkUnsafe().setPrettyPrinting().create();

    private PortalDebugPasteCommand(PortalsPlugin plugin) {
        super(plugin, "debug-paste", "portals.command.debug-paste");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        PortalDebugPasteCommand command = new PortalDebugPasteCommand(plugin);
        return (LiteralArgumentBuilder)command.create().executes((Command)command);
    }

    @Override
    protected boolean canUse(CommandSourceStack source) {
        return super.canUse(source) && source.getSender() instanceof Player;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        JsonObject debug = new JsonObject();
        JsonArray logs = new JsonArray();
        JsonArray portals = new JsonArray();
        debug.addProperty("version", this.plugin.getPluginMeta().getVersion());
        debug.addProperty("server", this.plugin.getServer().getName() + " " + this.plugin.getServer().getVersion());
        debug.addProperty("uptime", DurationAdapter.toString(Duration.ofMillis(this.plugin.uptime())));
        if (this.plugin.omittedLogs() > 0) {
            logs.add((JsonElement)new JsonPrimitive("Omitted " + this.plugin.omittedLogs() + " logs"));
        }
        this.plugin.portalProvider().portals.stream().map(arg_0 -> ((Gson)this.gson).toJsonTree(arg_0)).forEach(arg_0 -> ((JsonArray)portals).add(arg_0));
        this.plugin.logs().map(JsonPrimitive::new).forEach(arg_0 -> ((JsonArray)logs).add(arg_0));
        debug.add("config", this.gson.toJsonTree((Object)this.plugin.config()));
        debug.add("portals", (JsonElement)portals);
        debug.add("logs", (JsonElement)logs);
        this.plugin.bundle().sendMessage((Audience)sender, "portal.debug-paste", new TagResolver[]{Placeholder.parsed((String)"debug", (String)this.gson.toJson((JsonElement)debug))});
        return 1;
    }

    private static final class DebugExclusionStrategy
    implements ExclusionStrategy {
        private DebugExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.equals(PortalsPlugin.class);
        }
    }
}

