/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.commands.PortalCommand;
import net.thenextlvl.portals.plugin.commands.arguments.DurationArgumentType;
import net.thenextlvl.portals.plugin.commands.brigadier.SimpleCommand;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class PortalCooldownCommand
extends SimpleCommand {
    public PortalCooldownCommand(PortalsPlugin plugin) {
        super(plugin, "cooldown", "portals.command.cooldown");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        PortalCooldownCommand command = new PortalCooldownCommand(plugin);
        RequiredArgumentBuilder cooldown = Commands.argument((String)"cooldown", (ArgumentType)DurationArgumentType.duration());
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)PortalCommand.portalArgument(plugin).then(cooldown.executes((Command)command))).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Portal portal = (Portal)context.getArgument("portal", Portal.class);
        Duration cooldown = this.tryGetArgument(context, "cooldown", Duration.class).orElse(null);
        if (cooldown == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "portal.cooldown.current", new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName()), Formatter.number((String)"cooldown", (Number)((double)portal.getCooldown().toMillis() / 1000.0))});
            return 1;
        }
        boolean success = portal.setCooldown(cooldown);
        String message = success ? "portal.cooldown.set" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName()), Formatter.number((String)"cooldown", (Number)((double)cooldown.toMillis() / 1000.0))});
        return success ? 1 : 0;
    }
}

