/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.adapters.debug;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Duration;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DurationAdapter
implements JsonSerializer<Duration> {
    public JsonElement serialize(Duration duration, Type type, JsonSerializationContext context) {
        return new JsonPrimitive(DurationAdapter.toString(duration));
    }

    public static String toString(Duration duration) {
        long millis = duration.toMillis();
        if (millis < 1000L) {
            return millis + " milliseconds";
        }
        long seconds = duration.toSeconds();
        if (Math.abs(seconds) < 60L) {
            return seconds + " seconds";
        }
        long minutes = duration.toMinutes();
        if (Math.abs(minutes) < 60L) {
            return minutes + " minutes";
        }
        long hours = duration.toHours();
        if (Math.abs(hours) < 24L) {
            return hours + " hours";
        }
        return duration.toDays() + " days";
    }
}

