/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag;

import java.io.IOException;
import java.util.Arrays;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.LongArrayTag;
import net.thenextlvl.nbt.tag.ValueTagImpl;

final class LongArrayTagImpl
extends ValueTagImpl<long[]>
implements LongArrayTag {
    public LongArrayTagImpl(long ... value) {
        super(value);
    }

    @Override
    public byte getTypeId() {
        return 12;
    }

    @Override
    public int size() {
        return ((long[])this.value).length;
    }

    @Override
    public Long get(int index) {
        return ((long[])this.value)[index];
    }

    @Override
    public long[] getValue() {
        return (long[])((long[])this.value).clone();
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeLong(((long[])this.value).length);
        for (long l : (long[])this.value) {
            outputStream.writeLong(l);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongArrayTagImpl)) {
            return false;
        }
        LongArrayTagImpl valueTag = (LongArrayTagImpl)object;
        return Arrays.equals((long[])this.value, (long[])valueTag.value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((long[])this.value);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{value=" + Arrays.toString((long[])this.value) + "}";
    }
}

