/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.thenextlvl.nbt.tag.ListTagImpl;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.nbt.tag.ValueTag;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;

public sealed interface ListTag<T extends Tag>
extends ValueTag<List<T>>,
List<T>
permits ListTagImpl {
    public static final byte ID = 9;

    @Contract(pure=true)
    public byte getContentTypeId();

    @SafeVarargs
    @Contract(value="_, _ -> new", pure=true)
    public static <T extends Tag> ListTag<T> of(byte contentTypeId, T ... content) throws IllegalArgumentException {
        return ListTag.of(contentTypeId, List.of(content));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <T extends Tag> ListTag<T> of(byte contentTypeId, List<T> content) throws IllegalArgumentException {
        return ListTag.builder().contentType(contentTypeId).addAll(content).build();
    }

    @SafeVarargs
    @Contract(value="_ -> new", pure=true)
    public static <T extends Tag> ListTag<T> of(T ... content) throws IllegalArgumentException {
        return ListTag.of(List.of(content));
    }

    @Contract(value="_ -> new", pure=true)
    public static <T extends Tag> ListTag<T> of(List<T> content) throws IllegalArgumentException {
        return ListTag.builder().addAll(content).build();
    }

    @Contract(value="_ -> new", pure=true)
    public static <T extends Tag> ListTag<T> empty(byte contentTypeId) {
        return new ListTagImpl(contentTypeId);
    }

    @Contract(value=" -> new", pure=true)
    public static <T extends Tag> Builder<T> builder() {
        return new ListTagImpl.Builder();
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public boolean add(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_, _ -> fail")
    default public void add(int i, T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public boolean addAll(Collection<? extends T> collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_, _ -> fail")
    default public boolean addAll(int i, Collection<? extends T> collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public boolean remove(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public boolean removeAll(Collection<?> collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public boolean retainAll(Collection<?> collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public void addFirst(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public void addLast(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public boolean removeIf(Predicate<? super T> filter) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public T remove(int i) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value=" -> fail")
    default public T removeFirst() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value=" -> fail")
    default public T removeLast() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    default public void replaceAll(UnaryOperator<T> operator) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value=" -> fail")
    default public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    @Deprecated
    @Contract(value="_, _ -> fail")
    default public T set(int i, T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    public static sealed interface Builder<T extends Tag>
    permits ListTagImpl.Builder {
        @Contract(value="_ -> this", mutates="this")
        public Builder<T> contentType(byte var1) throws IllegalStateException;

        @Contract(value="_ -> this", mutates="this")
        public Builder<T> add(T var1) throws IllegalArgumentException;

        @Contract(value="_, _ -> this", mutates="this")
        public Builder<T> add(int var1, T var2) throws IllegalArgumentException;

        @Contract(value="_ -> this", mutates="this")
        public Builder<T> addFirst(T var1) throws IllegalArgumentException;

        @Contract(value="_ -> this", mutates="this")
        public Builder<T> addLast(T var1) throws IllegalArgumentException;

        @Contract(value="_ -> this", mutates="this")
        @Flow(sourceIsContainer=true, targetIsContainer=true)
        public Builder<T> addAll(Iterable<? extends T> var1) throws IllegalArgumentException;

        @Contract(value="_ -> this", mutates="this")
        public Builder<T> replaceAll(UnaryOperator<T> var1) throws IllegalArgumentException;

        @Contract(value="_, _ -> this", mutates="this")
        public Builder<T> set(int var1, T var2) throws IllegalArgumentException;

        @Contract(value="_ -> this", mutates="this")
        public Builder<T> remove(T var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder<T> removeIf(Predicate<? super T> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder<T> removeAll(Iterable<? extends T> var1) throws IllegalArgumentException;

        @Contract(value=" -> this", mutates="this")
        public Builder<T> clear();

        @Contract(value=" -> new", pure=true)
        public ListTag<T> build();
    }
}

