/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.ByteArrayTagImpl;
import net.thenextlvl.nbt.tag.ByteTag;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.EscapeTagImpl;
import net.thenextlvl.nbt.tag.IntArrayTagImpl;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.LongArrayTagImpl;
import net.thenextlvl.nbt.tag.NumberTag;
import net.thenextlvl.nbt.tag.StringTagImpl;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.nbt.tag.ValueTagImpl;
import org.jspecify.annotations.NullUnmarked;

final class CompoundTagImpl
extends ValueTagImpl<Map<String, Tag>>
implements CompoundTag {
    public CompoundTagImpl(Map<String, Tag> value) {
        super(Collections.unmodifiableMap(new LinkedHashMap<String, Tag>(value)));
    }

    public CompoundTagImpl() {
        super(Collections.emptyMap());
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public CompoundTag getAsCompound() {
        return this;
    }

    @Override
    public byte getTypeId() {
        return 10;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Tag> action) {
        ((Map)this.value).forEach(action);
    }

    @Override
    public Set<Map.Entry<String, Tag>> entrySet() {
        return ((Map)this.value).entrySet();
    }

    @Override
    public Set<String> keySet() {
        return ((Map)this.value).keySet();
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.value).isEmpty();
    }

    @Override
    public int size() {
        return ((Map)this.value).size();
    }

    @Override
    public boolean containsKey(String property) {
        return ((Map)this.value).containsKey(property);
    }

    @Override
    @NullUnmarked
    public <T extends Tag> T get(String property) {
        return (T)((Tag)((Map)this.value).get(property));
    }

    @Override
    public <E extends Tag> ListTag<E> getAsList(String tag) {
        return this.get(tag).getAsList();
    }

    @Override
    public CompoundTag getAsCompound(String tag) {
        return this.get(tag).getAsCompound();
    }

    @Override
    @NullUnmarked
    public <T extends Tag> T getOrDefault(String tag, T defaultValue) {
        return ((Map)this.value).getOrDefault(tag, defaultValue);
    }

    @Override
    public <T extends Tag> Optional<T> optional(String tag) {
        return Optional.ofNullable(this.get(tag)).map(value -> (Tag)value);
    }

    @Override
    public CompoundTag.Builder toBuilder() {
        return new Builder().putAll(this);
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        for (Map.Entry<String, Tag> entry : this.entrySet()) {
            outputStream.writeTag(entry.getKey(), entry.getValue());
        }
        EscapeTagImpl.INSTANCE.write(outputStream);
    }

    public static CompoundTag.Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements CompoundTag.Builder {
        private final Map<String, Tag> values = new LinkedHashMap<String, Tag>();

        @Override
        public Builder put(String name, boolean value) {
            return this.put(name, ByteTag.of(value));
        }

        @Override
        public Builder put(String name, byte ... array) {
            return this.put(name, new ByteArrayTagImpl(array));
        }

        @Override
        public Builder put(String name, int ... array) {
            return this.put(name, new IntArrayTagImpl(array));
        }

        @Override
        public Builder put(String name, long ... array) {
            return this.put(name, new LongArrayTagImpl(array));
        }

        @Override
        public Builder put(String name, Number number) {
            return this.put(name, NumberTag.of(number));
        }

        @Override
        public Builder put(String name, String value) {
            return this.put(name, new StringTagImpl(value));
        }

        @Override
        public Builder put(String name, Tag tag) {
            this.values.put(name, tag);
            return this;
        }

        @Override
        public Builder putAll(CompoundTag tag) {
            this.values.putAll((Map)tag.getValue());
            return this;
        }

        @Override
        public CompoundTag build() {
            return new CompoundTagImpl(this.values);
        }
    }
}

