/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.listeners;

import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.math.Position;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.event.EntityPortalExitEvent;
import net.thenextlvl.portals.event.PreEntityPortalEnterEvent;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PortalListener
implements Listener {
    private static final Map<Portal, Map<UUID, Instant>> lastEntry = new HashMap<Portal, Map<UUID, Instant>>();
    private static final Map<UUID, Portal> lastPortal = new HashMap<UUID, Portal>();
    private final PortalsPlugin plugin;

    public PortalListener(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityMove(EntityMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        if (this.plugin.config().ignoreEntityMovement()) {
            return;
        }
        if (this.processMovement((Entity)event.getEntity(), event.getTo())) {
            return;
        }
        this.pushAway((Entity)event.getEntity(), event.getTo());
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        if (this.processMovement((Entity)event.getPlayer(), event.getTo())) {
            return;
        }
        this.pushAway((Entity)event.getPlayer(), event.getTo());
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (event.isSneaking()) {
            return;
        }
        if (this.processMovement((Entity)event.getPlayer(), event.getPlayer().getLocation())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityPortalEnter(EntityPortalEnterEvent event) {
        this.plugin.portalProvider().getPortals(event.getLocation().getWorld()).filter(portal -> portal.getBoundingBox().contains((Position)event.getLocation())).findAny().ifPresent(portal -> event.setCancelled(true));
    }

    private boolean processMovement(Entity entity, Location to) {
        BoundingBox boundingBox = PortalListener.translate(entity.getBoundingBox(), to);
        return this.plugin.portalProvider().getPortals(entity.getWorld()).filter(portal -> portal.getBoundingBox().overlaps(boundingBox)).findAny().map(portal -> {
            if (portal.equals(lastPortal.get(entity.getUniqueId()))) {
                return true;
            }
            if (!new PreEntityPortalEnterEvent((Portal)portal, entity).callEvent()) {
                return false;
            }
            if (!portal.getEntryPermission().map(arg_0 -> ((Entity)entity).hasPermission(arg_0)).orElse(true).booleanValue()) {
                return false;
            }
            if (portal.getCooldown().isPositive() && PortalListener.hasCooldown(portal, entity)) {
                return false;
            }
            if (portal.getEntryCost() > 0.0 && !this.withdrawEntryCost((Portal)portal, entity)) {
                return false;
            }
            if (!new net.thenextlvl.portals.event.EntityPortalEnterEvent((Portal)portal, entity).callEvent()) {
                return false;
            }
            if (portal.getCooldown().isPositive()) {
                PortalListener.setLastEntry(portal, entity);
            }
            PortalListener.setLastPortal(entity, portal);
            return portal.getEntryAction().map(action -> action.onEntry(entity, (Portal)portal)).orElse(true);
        }).orElseGet(() -> {
            Portal removed = lastPortal.remove(entity.getUniqueId());
            if (removed != null) {
                new EntityPortalExitEvent(removed, entity).callEvent();
            }
            return true;
        });
    }

    private void pushAway(Entity entity, Location to) {
        double speed = this.plugin.config().pushbackSpeed();
        if (speed > 0.0) {
            entity.getScheduler().run((Plugin)this.plugin, task -> {
                Vector direction = entity.getLocation().toVector().subtract(to.toVector()).normalize();
                entity.setVelocity(direction.multiply(speed));
            }, null);
        }
    }

    private boolean withdrawEntryCost(Portal portal, Entity entity) {
        if (!this.plugin.config().entryCosts()) {
            return true;
        }
        if (!(entity instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        return this.plugin.economyProvider().withdraw(player, portal.getEntryCost());
    }

    public static void setLastPortal(Entity entity, Portal portal) {
        lastPortal.put(entity.getUniqueId(), portal);
    }

    private static BoundingBox translate(BoundingBox boundingBox, Location location) {
        double widthX = boundingBox.getWidthX() / 2.0;
        double widthZ = boundingBox.getWidthZ() / 2.0;
        return new BoundingBox(location.getX() - widthX, location.getY(), location.getZ() - widthZ, location.getX() + widthX, location.getY() + boundingBox.getHeight(), location.getZ() + widthZ);
    }

    private static boolean hasCooldown(Portal portal, Entity entity) {
        Map<UUID, Instant> entries = lastEntry.get(portal);
        if (entries == null) {
            return false;
        }
        Instant lastEntry = entries.get(entity.getUniqueId());
        return lastEntry != null && Instant.now().isBefore(lastEntry.plus(portal.getCooldown()));
    }

    private static void setLastEntry(Portal portal, Entity entity) {
        lastEntry.computeIfAbsent(portal, ignored -> new HashMap()).put(entity.getUniqueId(), Instant.now());
    }
}

