/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.commands.action;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.action.ActionTypes;
import net.thenextlvl.portals.plugin.PortalsPlugin;
import net.thenextlvl.portals.plugin.commands.action.ActionCommand;
import net.thenextlvl.portals.plugin.model.LazyLocation;
import org.bukkit.Location;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class TeleportCommand
extends ActionCommand<Location> {
    private TeleportCommand(PortalsPlugin plugin) {
        super(plugin, ActionTypes.types().teleport(), "teleport");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        TeleportCommand command = new TeleportCommand(plugin);
        RequiredArgumentBuilder position = (RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)ArgumentTypes.finePosition()).executes((Command)command);
        RequiredArgumentBuilder rotation = (RequiredArgumentBuilder)Commands.argument((String)"rotation", (ArgumentType)ArgumentTypes.rotation()).executes((Command)command);
        RequiredArgumentBuilder world = (RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes((Command)command);
        return (LiteralArgumentBuilder)command.create().then(world.then(position.then((ArgumentBuilder)rotation)));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        World world = (World)context.getArgument("world", World.class);
        Location location = this.resolveArgument(context, "position", FinePositionResolver.class).orElseGet(() -> ((World)world).getSpawnLocation()).toLocation(world);
        this.resolveArgument(context, "rotation", RotationResolver.class).ifPresent(arg_0 -> ((Location)location).setRotation(arg_0));
        return this.addAction(context, new LazyLocation(location));
    }

    @Override
    protected void onSuccess(CommandContext<CommandSourceStack> context, Portal portal, Location input) {
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "portal.action.teleport", new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName()), Placeholder.parsed((String)"world", (String)input.getWorld().getName()), Formatter.number((String)"x", (Number)input.getX()), Formatter.number((String)"y", (Number)input.getY()), Formatter.number((String)"z", (Number)input.getZ())});
    }
}

