/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.plugin.action;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.thenextlvl.portals.action.ActionType;
import net.thenextlvl.portals.action.ActionTypeRegistry;
import net.thenextlvl.portals.action.ActionTypes;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SimpleActionTypeRegistry
implements ActionTypeRegistry {
    public static final SimpleActionTypeRegistry INSTANCE = new SimpleActionTypeRegistry();
    private final Set<ActionType<?>> actionTypes = new HashSet<ActionType<InetSocketAddress>>(Set.of(ActionTypes.types().connect(), ActionTypes.types().runCommand(), ActionTypes.types().runConsoleCommand(), ActionTypes.types().teleport(), ActionTypes.types().teleportPortal(), ActionTypes.types().teleportRandom(), ActionTypes.types().transfer()));

    @Override
    public boolean register(ActionType<?> type) {
        return !this.isRegistered(type.getName()) && this.actionTypes.add(type);
    }

    @Override
    public boolean isRegistered(ActionType<?> type) {
        return this.actionTypes.contains(type);
    }

    @Override
    public boolean isRegistered(String name) {
        return this.actionTypes.stream().anyMatch(actionType -> actionType.getName().equals(name));
    }

    @Override
    public boolean unregister(ActionType<?> type) {
        return this.actionTypes.remove(type);
    }

    @Override
    public <T> Optional<ActionType<T>> getByName(String name) {
        return this.actionTypes.stream().filter(actionType -> actionType.getName().equals(name)).map(actionType -> actionType).findAny();
    }

    @Override
    public @Unmodifiable Set<ActionType<?>> getActionTypes() {
        return Set.copyOf(this.actionTypes);
    }
}

