/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.portal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.PortalProvider;
import net.thenextlvl.portals.PortalsPlugin;
import net.thenextlvl.portals.portal.PaperPortal;
import net.thenextlvl.portals.shape.BoundingBox;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PaperPortalProvider
implements PortalProvider {
    public final Set<Portal> portals = new HashSet<Portal>();
    private final PortalsPlugin plugin;

    public PaperPortalProvider(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Path getDataFolder(World world) {
        return world.getWorldPath().resolve("portals");
    }

    @Override
    public Optional<Portal> getPortal(String name) {
        return this.getPortals().filter(portal -> portal.getName().equals(name)).findAny();
    }

    @Override
    public Stream<Portal> getPortals() {
        return this.portals.stream();
    }

    @Override
    public Stream<Portal> getPortals(World world) {
        return this.getPortals().filter(portal -> portal.getWorld().equals((Object)world));
    }

    @Override
    public Portal createPortal(String name, BoundingBox boundingBox) throws IllegalArgumentException {
        Preconditions.checkArgument((!this.hasPortal(name) ? 1 : 0) != 0, (String)"Portal with name '%s' already exists", (Object)name);
        PaperPortal portal = new PaperPortal(this.plugin, name, boundingBox);
        this.portals.add(portal);
        return portal;
    }

    @Override
    public boolean hasPortal(Portal portal) {
        return this.portals.contains(portal);
    }

    @Override
    public boolean hasPortal(String name) {
        return this.getPortals().anyMatch(portal -> portal.getName().equals(name));
    }

    @Override
    public boolean deletePortal(Portal portal) {
        try {
            if (!this.portals.remove(portal)) {
                return false;
            }
            Files.deleteIfExists(portal.getDataFile());
            Files.deleteIfExists(portal.getBackupFile());
            return true;
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().error("Failed to delete portal {}", (Object)portal.getName(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean deletePortal(String name) {
        return this.getPortal(name).map(this::deletePortal).orElse(false);
    }

    @Override
    public void forEachPortal(Consumer<Portal> action) {
        this.portals.forEach(action);
    }
}

