/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.PortalsPlugin;
import net.thenextlvl.portals.command.brigadier.SimpleCommand;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.WorldInfo;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class PortalListCommand
extends SimpleCommand {
    public PortalListCommand(PortalsPlugin plugin) {
        super(plugin, "list", "portals.command.list");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        PortalListCommand command = new PortalListCommand(plugin);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes((Command)command))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Optional<World> world = this.tryGetArgument(context, "world", World.class);
        List<Component> portals = world.map(this.plugin.portalProvider()::getPortals).orElseGet(this.plugin.portalProvider()::getPortals).map(portal -> this.plugin.bundle().component("portal.list.entry", (Audience)sender, new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName())})).toList();
        String message = world.map(ignored -> portals.isEmpty() ? "portal.list.empty.world" : "portal.list.world").orElseGet(() -> portals.isEmpty() ? "portal.list.empty" : "portal.list");
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"world", (String)world.map(WorldInfo::getName).orElse("")), Formatter.number((String)"count", (Number)portals.size()), Formatter.joining((String)"portals", portals)});
        return 1;
    }
}

